/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.traceability;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import org.eclipse.epsilon.egl.traceability.Content;
import org.eclipse.epsilon.egl.traceability.Template;

public abstract class Container
extends Content<Template> {
    private final String name;
    private final URI uri;
    protected final Collection<Object> contents = new LinkedList<Object>();

    protected Container(Template parent, String name, URI uri) {
        super(parent);
        Objects.requireNonNull(name, "name cannot be null");
        this.name = name;
        this.uri = uri;
    }

    public String getName() {
        return this.name;
    }

    public URI getURI() {
        return this.uri;
    }

    public void add(Object child) {
        if (child == this) {
            return;
        }
        if (child instanceof Content) {
            ((Content)child).setParent(this);
        }
        this.contents.add(child);
    }

    public Collection<?> getChildren() {
        return Collections.unmodifiableCollection(this.contents);
    }

    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Container)) {
            return false;
        }
        Container that = (Container)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.uri, that.uri) && Objects.equals(this.contents, that.contents);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.uri, this.contents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        if (!this.contents.isEmpty()) {
            sb.append(' ').append(this.contents);
        }
        return sb.toString();
    }
}

