/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.traceability;

import java.util.Objects;
import org.eclipse.epsilon.egl.traceability.Content;
import org.eclipse.epsilon.egl.traceability.OutputFile;

public class ProtectedRegion
extends Content<OutputFile> {
    private final String id;
    private final boolean enabled;
    private final int offset;

    protected ProtectedRegion(OutputFile parent, String id, boolean enabled, int offset) {
        super(parent);
        Objects.requireNonNull(parent, "parent cannot be null");
        Objects.requireNonNull(id, "id cannot be null");
        this.id = id;
        this.enabled = enabled;
        this.offset = offset;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getId() {
        return this.id;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProtectedRegion)) {
            return false;
        }
        ProtectedRegion that = (ProtectedRegion)o;
        return this.id.equals(that.id) && this.enabled == that.enabled && this.offset == that.offset;
    }

    public int hashCode() {
        int result = 17;
        result += 37 * result + this.id.hashCode();
        result += 37 * result + (this.enabled ? 1 : 0);
        result += 37 * result + this.offset;
        return result;
    }

    public String toString() {
        return String.valueOf(this.id) + "[" + (this.enabled ? "on" : "off") + "]" + "@" + this.offset;
    }
}

