/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.traceability;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.epsilon.egl.traceability.Content;
import org.eclipse.epsilon.egl.traceability.Template;

public class Variable
extends Content<Template> {
    private final String name;
    private final Object value;

    protected Variable(Template parent, String name, Object value) {
        super(parent);
        Objects.requireNonNull(name, "name cannot be null");
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Variable)) {
            return false;
        }
        Variable that = (Variable)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = 17;
        result += 37 * result + this.name.hashCode();
        result += 37 * result + Objects.hashCode(this.value);
        return result;
    }

    public String toString() {
        return String.valueOf(this.name) + "=" + Objects.toString(this.value);
    }

    public Map.Entry<String, Object> asEntry() {
        return new AbstractMap.SimpleEntry<String, Object>(this.name, this.value);
    }
}

