/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Objects;

public abstract class FileUtil {
    public static final String FILE_SEP = System.getProperty("file.separator");
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String ESCAPED_NEWLINE = NEWLINE.replaceAll("\\r", "\\\\r").replaceAll("\\n", "\\\\n");

    private FileUtil() {
    }

    public static String resolve(String path, File parent) {
        File file = new File(Objects.requireNonNull(path, "path may not be null"));
        if (!file.isAbsolute() && parent != null) {
            file = new File(parent, path);
        }
        return file.getAbsolutePath();
    }

    public static String readIfExists(File file) throws IOException {
        return file.exists() ? FileUtil.read(file) : null;
    }

    public static String read(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            int c;
            StringBuilder contents = new StringBuilder();
            while ((c = reader.read()) != -1) {
                if ((char)c == '\r' && (char)reader.read() == '\n') {
                    contents.append(NEWLINE);
                    continue;
                }
                if ((char)c == '\n') {
                    contents.append(NEWLINE);
                    continue;
                }
                contents.append((char)c);
            }
            return contents.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void write(String path, String contents) throws IOException {
        FileUtil.write(new File(path), contents);
    }

    public static void write(String path, String contents, boolean append) throws IOException {
        FileUtil.write(new File(path), contents, append);
    }

    public static void write(File file, String contents) throws IOException {
        FileUtil.write(file, contents, false);
    }

    public static void write(File file, String contents, boolean append) throws IOException {
        if (!file.getAbsoluteFile().getParentFile().exists()) {
            file.getAbsoluteFile().getParentFile().mkdirs();
        }
        file.createNewFile();
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileWriter writer = new FileWriter(file, append);){
            writer.write(contents);
            writer.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

