/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.emf.AbstractReflectiveEmfModel;
import org.eclipse.epsilon.emc.emf.CachedResourceSet;
import org.eclipse.epsilon.emc.emf.ContainmentChangeAdapter;
import org.eclipse.epsilon.emc.emf.DefaultXMIResource;
import org.eclipse.epsilon.emc.emf.EmfModelMetamodel;
import org.eclipse.epsilon.emc.emf.EmfPropertySetter;
import org.eclipse.epsilon.emc.emf.EmfUtil;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.m3.Metamodel;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;

public class EmfModel
extends AbstractReflectiveEmfModel {
    @Deprecated
    public static final String PROPERTY_IS_METAMODEL_FILE_BASED = "isMetamodelFileBased";
    public static final String PROPERTY_METAMODEL_URI = "metamodelUri";
    public static final String PROPERTY_FILE_BASED_METAMODEL_URI = "fileBasedMetamodelUri";
    @Deprecated
    public static final String PROPERTY_METAMODEL_FILE = "metamodelFile";
    public static final String PROPERTY_MODEL_URI = "modelUri";
    @Deprecated
    public static final String PROPERTY_MODEL_FILE = "modelFile";
    public static final String PROPERTY_REUSE_UNMODIFIED_FILE_BASED_METAMODELS = "reuseUnmodifiedFileBasedMetamodels";
    public static final String PROPERTY_VALIDATE = "validate";
    protected List<URI> metamodelUris = new ArrayList<URI>();
    protected List<EPackage> packages;
    @Deprecated
    protected boolean isMetamodelFileBased = false;
    protected URI modelUri;
    protected List<URI> metamodelFileUris = new ArrayList<URI>();
    protected boolean useExtendedMetadata = false;
    protected boolean validate = false;
    protected boolean reuseUnmodifiedFileBasedMetamodels = true;
    protected static Map<String, List<EPackage>> fileBasedMetamodels = new HashMap<String, List<EPackage>>();
    protected static Map<String, Long> fileBasedMetamodelTimestamps = new HashMap<String, Long>();

    public EmfModel() {
        this.propertySetter = new EmfPropertySetter();
    }

    @Override
    public void load(StringProperties properties, IRelativePathResolver resolver) throws EolModelLoadingException {
        PropertyMigrator.migrateDeprecatedProperties(properties);
        super.load(properties, resolver);
        this.modelUri = URI.createURI((String)properties.getProperty(PROPERTY_MODEL_URI));
        this.isMetamodelFileBased = properties.getBooleanProperty(PROPERTY_IS_METAMODEL_FILE_BASED, this.isMetamodelFileBased);
        this.metamodelUris = EmfModel.toURIList(properties.getProperty(PROPERTY_METAMODEL_URI));
        this.setMetamodelFileUris(EmfModel.toURIList(properties.getProperty(PROPERTY_FILE_BASED_METAMODEL_URI)));
        this.setReuseUnmodifiedFileBasedMetamodels(properties.getBooleanProperty(PROPERTY_REUSE_UNMODIFIED_FILE_BASED_METAMODELS, this.reuseUnmodifiedFileBasedMetamodels));
        this.setValidate(properties.getBooleanProperty(PROPERTY_VALIDATE, false));
        this.load();
    }

    protected void loadModel() throws EolModelLoadingException {
        this.loadModelFromUri();
        if (this.validate) {
            this.validate();
        }
        this.setupContainmentChangeListeners();
    }

    protected void addToCache(String type, EObject instance) throws EolModelElementTypeNotFoundException {
    }

    protected void removeFromCache(EObject instance) throws EolModelElementTypeNotFoundException {
    }

    protected void forceAddToCache(EObject instance) throws EolModelElementTypeNotFoundException {
        super.addToCache(this.getFullyQualifiedTypeNameOf(instance), (Object)instance);
        for (EObject child : instance.eContents()) {
            this.forceAddToCache(child);
        }
    }

    protected void forceRemoveFromCache(EObject instance) throws EolModelElementTypeNotFoundException {
        super.removeFromCache((Object)instance);
        for (EObject child : instance.eContents()) {
            this.forceRemoveFromCache(child);
        }
    }

    public void setupContainmentChangeListeners() {
        if (this.modelImpl != null) {
            for (EObject eObject : this.allContents()) {
                boolean isAdapted = false;
                for (Adapter adapter : eObject.eAdapters()) {
                    if (!(adapter instanceof ContainmentChangeAdapter)) continue;
                    isAdapted = true;
                }
                if (isAdapted) continue;
                eObject.eAdapters().add((Object)new ContainmentChangeAdapter(eObject, eObject.eResource()));
            }
        }
    }

    protected ResourceSet createResourceSet() {
        return new CachedResourceSet();
    }

    public void loadModelFromUri() throws EolModelLoadingException {
        ResourceSet resourceSet = this.createResourceSet();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("model", new DefaultXMIResource.Factory());
        if (EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/Ecore") == null) {
            EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        }
        this.determinePackagesFrom(resourceSet);
        for (EPackage ep : this.packages) {
            String nsUri = ep.getNsURI();
            if (nsUri == null || nsUri.trim().length() == 0) {
                nsUri = ep.getName();
            }
            resourceSet.getPackageRegistry().put((Object)nsUri, (Object)ep);
        }
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        this.modelImpl = resourceSet.createResource(this.modelUri);
        if (this.readOnLoad) {
            try {
                this.modelImpl.load(this.getResourceLoadOptions());
                if (this.expand) {
                    EcoreUtil.resolveAll((Resource)this.modelImpl);
                }
            }
            catch (IOException e) {
                this.disposeModel();
                throw new EolModelLoadingException((Exception)e, (IModel)this);
            }
        }
        if (this.isCachingEnabled()) {
            this.addContentsAdapter();
        }
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        boolean wasEnabled = this.isCachingEnabled();
        super.setCachingEnabled(cachingEnabled);
        if (this.modelImpl != null) {
            if (!wasEnabled && cachingEnabled && !this.hasAdapter(CachedContentsAdapter.class)) {
                this.addContentsAdapter();
            } else if (wasEnabled && !cachingEnabled) {
                this.removeContentsAdapter();
            }
        }
    }

    protected void removeContentsAdapter() {
        this.modelImpl.eAdapters().removeIf(a -> a instanceof CachedContentsAdapter);
    }

    protected void addContentsAdapter() {
        this.modelImpl.eAdapters().add((Object)new CachedContentsAdapter());
    }

    @Override
    public void disposeModel() {
        if (this.modelImpl != null && this.isCachingEnabled()) {
            this.removeContentsAdapter();
        }
        super.disposeModel();
    }

    public List<String> getMetamodelFiles() {
        ArrayList<String> files = new ArrayList<String>(this.metamodelFileUris.size());
        for (URI metamodelFileUri : this.metamodelFileUris) {
            files.add(EmfUtil.getFile(metamodelFileUri));
        }
        return files;
    }

    @Deprecated
    public boolean isMetamodelFileBased() {
        return this.isMetamodelFileBased;
    }

    @Deprecated
    public void setMetamodelFileBased(boolean isMetamodelFileBased) {
        this.isMetamodelFileBased = isMetamodelFileBased;
    }

    public List<String> getMetamodelUris() {
        ArrayList<String> uris = new ArrayList<String>(this.metamodelUris.size());
        for (URI metamodelUri : this.metamodelUris) {
            uris.add(metamodelUri.toString());
        }
        return uris;
    }

    public String getModelFile() {
        return EmfUtil.getFile(this.modelUri);
    }

    public URI getModelFileUri() {
        return this.modelUri;
    }

    public void setModelFileUri(URI modelFileUri) {
        this.modelUri = modelFileUri;
    }

    public List<URI> getMetamodelFileUris() {
        return this.metamodelFileUris;
    }

    public void setMetamodelFileUris(List<URI> fileUris) {
        this.metamodelFileUris = new ArrayList<URI>(fileUris);
    }

    public void setMetamodelFileUri(URI uri) {
        this.metamodelFileUris = Arrays.asList(uri);
    }

    public void setMetamodelUris(List<String> uris) {
        this.metamodelUris.clear();
        CollectionUtil.addCapacityIfArrayList(this.metamodelUris, (int)uris.size());
        for (String sURI : uris) {
            this.metamodelUris.add(URI.createURI((String)sURI));
        }
    }

    public void setMetamodelUri(String uri) {
        this.metamodelUris = Arrays.asList(URI.createURI((String)uri));
    }

    public void setMetamodelFiles(List<String> paths) {
        this.metamodelFileUris.clear();
        CollectionUtil.addCapacityIfArrayList(this.metamodelFileUris, (int)paths.size());
        for (String sPath : paths) {
            this.metamodelFileUris.add(URI.createFileURI((String)sPath));
        }
    }

    public void setMetamodelFile(String path) {
        this.setMetamodelFileUri(URI.createFileURI((String)path));
    }

    public void setModelFile(String path) {
        this.modelUri = URI.createFileURI((String)path);
    }

    public boolean isReuseUnmodifiedFileBasedMetamodels() {
        return this.reuseUnmodifiedFileBasedMetamodels;
    }

    public void setReuseUnmodifiedFileBasedMetamodels(boolean reuseUnmodifiedFileBasedMetamodels) {
        this.reuseUnmodifiedFileBasedMetamodels = reuseUnmodifiedFileBasedMetamodels;
    }

    public String toString() {
        return "EmfModel [name=" + this.getName() + "]";
    }

    protected void determinePackagesFrom(ResourceSet resourceSet) throws EolModelLoadingException {
        this.packages = new ArrayList<EPackage>();
        for (URI metamodelFileUri : this.metamodelFileUris) {
            List<EPackage> metamodelPackages = null;
            try {
                metamodelPackages = this.attemptFileBasedMetamodelReuse(metamodelFileUri);
                if (metamodelPackages == null) {
                    metamodelPackages = EmfUtil.register(metamodelFileUri, resourceSet.getPackageRegistry(), false);
                    EmfModel.saveFileBasedMetamodelForReuse(metamodelFileUri, metamodelPackages);
                }
            }
            catch (Exception e) {
                throw new EolModelLoadingException(e, (IModel)this);
            }
            CollectionUtil.addCapacityIfArrayList(this.packages, (int)metamodelPackages.size());
            for (EPackage metamodelPackage : metamodelPackages) {
                this.packages.add(metamodelPackage);
                EmfUtil.collectDependencies(metamodelPackage, this.packages);
            }
        }
        CollectionUtil.addCapacityIfArrayList(this.packages, (int)this.metamodelUris.size());
        for (URI metamodelUri : this.metamodelUris) {
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(metamodelUri.toString());
            if (ePackage == null) {
                throw new EolModelLoadingException((Exception)new IllegalArgumentException("Could not locate a metamodel with the URI '" + metamodelUri + "'. Please ensure that this metamodel has been registered with Epsilon."), (IModel)this);
            }
            this.packages.add(ePackage);
            EmfUtil.collectDependencies(ePackage, this.packages);
        }
    }

    private List<EPackage> attemptFileBasedMetamodelReuse(URI uri) {
        if (!this.reuseUnmodifiedFileBasedMetamodels || !uri.isFile()) {
            return null;
        }
        String path = uri.toFileString();
        File metamodelFile = new File(path);
        Long lastTimestamp = fileBasedMetamodelTimestamps.get(path);
        if (lastTimestamp == null || metamodelFile.lastModified() != lastTimestamp.longValue()) {
            return null;
        }
        return fileBasedMetamodels.get(path);
    }

    private static void saveFileBasedMetamodelForReuse(URI uri, List<EPackage> packages) {
        if (!uri.isFile()) {
            return;
        }
        String path = uri.toFileString();
        File metamodelFile = new File(path);
        Long timestamp = metamodelFile.lastModified();
        fileBasedMetamodels.put(path, packages);
        fileBasedMetamodelTimestamps.put(path, timestamp);
    }

    private static List<URI> toURIList(String commaSeparatedList) {
        return Stream.of(commaSeparatedList.trim().split("\\s*,\\s*")).filter(s -> !s.isEmpty()).map(URI::createURI).collect(Collectors.toList());
    }

    public Metamodel getMetamodel(StringProperties properties, IRelativePathResolver resolver) {
        return new EmfModelMetamodel(properties, resolver);
    }

    public boolean store() {
        if (this.modelImpl == null) {
            return false;
        }
        try {
            Map<Object, Object> options = this.getResourceStoreOptions();
            if (!this.metamodelFileUris.isEmpty()) {
                if (options == null) {
                    options = new HashMap<Object, Object>();
                }
                options.put("SCHEMA_LOCATION", true);
            }
            this.modelImpl.save(options);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    protected class CachedContentsAdapter
    extends EContentAdapter {
        protected CachedContentsAdapter() {
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            Object notifier = notification.getNotifier();
            Object feature = notification.getFeature();
            if (notifier instanceof Resource && notification.getFeatureID(Resource.class) == 2) {
                this.handle(notification);
            } else if (feature instanceof EReference && ((EReference)feature).isContainment()) {
                this.handle(notification);
            }
        }

        protected void handle(Notification notification) {
            try {
                switch (notification.getEventType()) {
                    case 2: {
                        Object oldValue = notification.getOldValue();
                        if (oldValue != Boolean.TRUE && oldValue != Boolean.FALSE) {
                            EObject newValue;
                            if (oldValue != null) {
                                EmfModel.this.forceRemoveFromCache((EObject)oldValue);
                            }
                            if ((newValue = (EObject)notification.getNewValue()) != null) {
                                EmfModel.this.forceAddToCache(newValue);
                            }
                        }
                        break;
                    }
                    case 1: {
                        EObject newValue;
                        EObject oldValue = (EObject)notification.getOldValue();
                        if (oldValue != null) {
                            EmfModel.this.forceRemoveFromCache(oldValue);
                        }
                        if ((newValue = (EObject)notification.getNewValue()) != null) {
                            EmfModel.this.forceAddToCache(newValue);
                        }
                        break;
                    }
                    case 5: {
                        Collection newValues = (Collection)notification.getNewValue();
                        for (EObject newValue : newValues) {
                            EmfModel.this.forceAddToCache(newValue);
                        }
                        break;
                    }
                    case 6: {
                        Collection oldValues = (Collection)notification.getOldValue();
                        for (EObject oldContentValue : oldValues) {
                            EmfModel.this.forceRemoveFromCache(oldContentValue);
                        }
                        break;
                    }
                    case 3: {
                        EObject added = (EObject)notification.getNewValue();
                        EmfModel.this.forceAddToCache(added);
                        break;
                    }
                    case 4: {
                        EObject removed = (EObject)notification.getOldValue();
                        EmfModel.this.forceRemoveFromCache(removed);
                        break;
                    }
                }
            }
            catch (EolModelElementTypeNotFoundException ex) {
                ex.printStackTrace();
            }
        }
    }

    static class PropertyMigrator {
        PropertyMigrator() {
        }

        public static void migrateDeprecatedProperties(StringProperties properties) {
            PropertyMigrator.migrateModelFileProperty(properties);
            PropertyMigrator.migrateMetamodelFileProperty(properties);
        }

        private static void migrateModelFileProperty(StringProperties properties) {
            PropertyMigrator.migrateUriValue(properties, EmfModel.PROPERTY_MODEL_FILE, EmfModel.PROPERTY_MODEL_URI);
        }

        private static void migrateMetamodelFileProperty(StringProperties properties) {
            PropertyMigrator.migrateUriValue(properties, EmfModel.PROPERTY_METAMODEL_FILE, EmfModel.PROPERTY_FILE_BASED_METAMODEL_URI);
        }

        private static void migrateUriValue(StringProperties properties, String oldProperty, String newProperty) {
            if (properties.hasProperty(oldProperty) && !properties.hasProperty(newProperty)) {
                String oldValue = properties.getProperty(oldProperty);
                File oldFile = new File(oldValue);
                if (oldFile.canRead() || oldFile.getParentFile() != null && oldFile.getParentFile().canRead()) {
                    properties.put((Object)newProperty, (Object)EmfUtil.createFileBasedURI(oldValue));
                } else {
                    properties.put((Object)newProperty, (Object)EmfUtil.createPlatformResourceURI(oldValue));
                }
            }
        }
    }
}

