/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epsilon.emc.emf.EmfModelResourceSet;
import org.eclipse.epsilon.emc.emf.EmfUtil;
import org.eclipse.epsilon.emc.emf.InMemoryEmfModel;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.tools.AbstractTool;

public class EmfTool
extends AbstractTool {
    public EcoreUtil getECoreUtil() {
        return new EcoreUtil();
    }

    public Map<EObject, Collection<EStructuralFeature.Setting>> getCrossReferences(Object eObject) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(eObject);
        return EcoreUtil.CrossReferencer.find(list);
    }

    public void createModel(EObject eObject, String name) {
        Object model = this.context.getModelRepository().getModelByNameSafe(name);
        if (model == null) {
            model = new InMemoryEmfModel(name, eObject.eResource());
            this.context.getModelRepository().addModel(model);
        }
    }

    public IModel createModel2(EObject eObject, String name, String uri) {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(EmfUtil.createPlatformResourceURI(uri));
        r.getContents().add((Object)eObject);
        InMemoryEmfModel model = new InMemoryEmfModel(name, r);
        this.context.getModelRepository().addModel((IModel)model);
        return model;
    }

    public void registerEPackage(EPackage ePackage) {
        EPackage.Registry.INSTANCE.put((Object)ePackage.getNsURI(), (Object)ePackage);
    }

    public EPackage getEPackage(String nsUri) {
        return EPackage.Registry.INSTANCE.getEPackage(nsUri);
    }

    public Object validate(EObject eObject) {
        return Diagnostician.INSTANCE.validate(eObject);
    }

    public boolean resourceExists(String resource) {
        return new EmfModelResourceSet().getURIConverter().exists(EmfUtil.createFileBasedURI(resource), null);
    }

    public boolean modelElementExists(String uri) throws IOException {
        try {
            return this.getEObject(uri) != null;
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().endsWith("is not a valid feature")) {
                return false;
            }
            throw e;
        }
    }

    public EObject getEObject(String uri) throws IOException {
        String modelUri = uri.split("#")[0];
        String elementUri = uri.split("#")[1];
        Resource model = new EmfModelResourceSet().createResource(EmfUtil.createFileBasedURI(modelUri));
        if (model == null) {
            return null;
        }
        model.load(null);
        return model.getEObject(elementUri);
    }

    public String resolveURI(String target, String base) {
        URI targetUri = URI.createURI((String)target);
        String resolved = targetUri.isRelative() ? this.resolveRelativeUri(target, base) : targetUri.toString();
        return resolved;
    }

    private String resolveRelativeUri(String target, String base) {
        String targetFragment;
        String targetPath;
        if (target.contains("#")) {
            targetPath = target.split("#")[0];
            targetFragment = "#" + target.split("#")[1];
        } else {
            targetPath = target;
            targetFragment = "";
        }
        return String.valueOf(URI.createFileURI((String)targetPath).resolve(URI.createFileURI((String)base)).toFileString()) + targetFragment;
    }
}

