/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf.transactions;

import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epsilon.emc.emf.AbstractEmfModel;
import org.eclipse.epsilon.eol.models.transactions.IModelTransaction;

public class EmfModelTransaction
implements IModelTransaction {
    protected ChangeRecorder changeRecorder;
    protected AbstractEmfModel model;

    public EmfModelTransaction(AbstractEmfModel model) {
        this.model = model;
    }

    public void start() {
        Resource impl = this.model.getResource();
        ResourceSet rs = impl.getResourceSet();
        this.changeRecorder = rs != null ? new ChangeRecorder(rs) : new ChangeRecorder(impl);
    }

    public void commit() {
        if (this.changeRecorder != null) {
            this.changeRecorder.endRecording();
            this.changeRecorder = null;
        }
    }

    public void rollback() {
        if (this.changeRecorder != null) {
            this.changeRecorder.endRecording().applyAndReverse();
            this.model.clearCache();
            this.changeRecorder = null;
        }
    }

    public void dispose() {
        this.model = null;
    }
}

