/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf.xmi;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epsilon.emc.emf.xmi.EClassStructuralFeature;

public class PartialXMILoadConfiguration {
    protected Set<EClass> allOfType = new LinkedHashSet<EClass>();
    protected Set<EClass> allOfKind = new LinkedHashSet<EClass>();
    protected Set<EClassStructuralFeature> features = new LinkedHashSet<EClassStructuralFeature>();
    protected HashMap<EClass, EObject> placeholders = new HashMap();

    public EObject getPlaceholder(EClass eClass) {
        if (!this.placeholders.containsKey(eClass)) {
            this.placeholders.put(eClass, eClass.getEPackage().getEFactoryInstance().create(eClass));
        }
        return this.placeholders.get(eClass);
    }

    public Collection<EObject> getPlaceholders() {
        return this.placeholders.values();
    }

    public boolean isPlaceholder(EObject eObject) {
        return this.placeholders.values().contains(eObject);
    }

    public Set<EClass> getAllOfType() {
        return this.allOfType;
    }

    public Set<EClass> getAllOfKind() {
        return this.allOfKind;
    }

    public void addFeature(EClass eClass, EStructuralFeature eStructuralFeature) {
        EReference eReference;
        this.features.add(new EClassStructuralFeature(eClass, eStructuralFeature));
        if (eStructuralFeature instanceof EReference && !(eReference = (EReference)eStructuralFeature).isContainment()) {
            this.allOfKind.add((EClass)eStructuralFeature.getEType());
        }
    }

    public void addAllOfType(EClass eClass) {
        this.allOfType.add(eClass);
    }

    public void addAllOfKind(EClass eClass) {
        this.allOfKind.add(eClass);
    }

    public Set<EClassStructuralFeature> getFeatures() {
        return this.features;
    }

    public boolean shouldSetValue(EObject eObject, String name) {
        return this.features.stream().anyMatch(f -> f.getEClass().isInstance((Object)eObject) && f.getEStructuralFeature().getName().equals(name));
    }

    public boolean shouldCreateObject(EClassifier eClassifier, EObject parent, String feature) {
        if (eClassifier instanceof EClass) {
            EClass eClass = (EClass)eClassifier;
            if (this.allOfType.stream().anyMatch(t -> t == eClass) || this.allOfKind.stream().anyMatch(t -> t.isSuperTypeOf(eClass) || t == eClassifier)) {
                return true;
            }
            if (feature != null && parent != null) {
                EClass parentEClass = parent.eClass();
                EStructuralFeature eStructuralFeature = parentEClass.getEStructuralFeature(feature);
                return this.features.stream().anyMatch(f -> f.getEStructuralFeature() == eStructuralFeature && (f.getEClass() == parentEClass || f.getEClass().isSuperTypeOf(parentEClass)));
            }
        } else {
            return true;
        }
        return !(eClassifier instanceof EClass) || this.allOfKind.stream().anyMatch(t -> t == eClassifier);
    }
}

