/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf.xml;

import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.GenericXMLResourceFactoryImpl;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.emc.emf.CachedResourceSet;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.emc.emf.xml.MixedElementOperationContributor;
import org.eclipse.epsilon.emc.emf.xml.XmlPropertySetter;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.execute.operations.contributors.IOperationContributorProvider;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;

public class XmlModel
extends EmfModel
implements IOperationContributorProvider {
    public static final String PROPERTY_XSD_URI = "xsdUri";
    @Deprecated
    public static final String PROPERTY_XSD_FILE = "xsdFile";
    protected URI xsdUri;
    protected MixedElementOperationContributor mixedElementOperationContributor = new MixedElementOperationContributor();

    public XmlModel() {
        this.propertySetter = new XmlPropertySetter();
    }

    @Override
    public void load(StringProperties properties, IRelativePathResolver resolver) throws EolModelLoadingException {
        String uriStr = properties.getProperty(PROPERTY_XSD_URI);
        if (StringUtil.isEmpty((String)uriStr)) {
            String xsdFile = resolver.resolve(properties.getProperty(PROPERTY_XSD_FILE));
            this.xsdUri = URI.createFileURI((String)xsdFile);
        } else {
            this.xsdUri = URI.createURI((String)uriStr);
        }
        super.load(properties, resolver);
    }

    @Override
    protected void determinePackagesFrom(ResourceSet resourceSet) throws EolModelLoadingException {
        super.determinePackagesFrom(resourceSet);
        if (this.xsdUri != null && this.xsdUri.fileExtension() != null && this.xsdUri.fileExtension().equalsIgnoreCase("xsd")) {
            XSDEcoreBuilder xsdEcoreBuilder = new XSDEcoreBuilder();
            Collection ePackages = xsdEcoreBuilder.generate(this.xsdUri);
            CollectionUtil.addCapacityIfArrayList((Collection)this.packages, (int)ePackages.size());
            for (Object eObj : ePackages) {
                EPackage ePackage = (EPackage)eObj;
                if (StringUtil.isEmpty((String)ePackage.getNsURI())) {
                    ePackage.setNsURI(ePackage.getName());
                }
                this.packages.add(ePackage);
            }
        }
    }

    @Override
    protected ResourceSet createResourceSet() {
        return new CachedResourceSet(){

            @Override
            public Resource createNewResource(URI uri, String contentType) {
                return new GenericXMLResourceFactoryImpl().createResource(uri);
            }
        };
    }

    public OperationContributor getOperationContributor() {
        return this.mixedElementOperationContributor;
    }
}

