/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.plainxml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.emc.plainxml.Binding;
import org.eclipse.epsilon.emc.plainxml.DomUtil;
import org.eclipse.epsilon.emc.plainxml.PlainXMLOperationContributor;
import org.eclipse.epsilon.emc.plainxml.PlainXmlPropertyGetter;
import org.eclipse.epsilon.emc.plainxml.PlainXmlPropertySetter;
import org.eclipse.epsilon.emc.plainxml.PlainXmlType;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.execute.operations.contributors.IOperationContributorProvider;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.models.CachedModel;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PlainXmlModel
extends CachedModel<Element>
implements IOperationContributorProvider {
    protected String idAttributeName = "id";
    protected Document document;
    protected String uri;
    protected File file;
    protected String xml;
    protected PlainXMLOperationContributor operationContributor = new PlainXMLOperationContributor();
    protected ArrayList<Element> createdElements = new ArrayList();
    protected ArrayList<Binding> bindings = new ArrayList();
    protected static final String ELEMENT_TYPE = "Element";
    protected static final String DEFAULT_NEW_TAG_NAME = "element";
    public static final String PROPERTY_FILE = "file";
    public static final String PROPERTY_URI = "uri";

    public PlainXmlModel() {
        this.propertyGetter = new PlainXmlPropertyGetter(this);
        this.propertySetter = new PlainXmlPropertySetter(this);
    }

    public synchronized Node getRoot() {
        return this.document.getFirstChild();
    }

    public synchronized void setRoot(Node node) {
        Node oldRoot = this.getRoot();
        if (oldRoot != null) {
            this.document.removeChild(oldRoot);
        }
        this.document.appendChild(node);
    }

    protected synchronized Collection<Element> allContentsFromModel() {
        ArrayList<Element> elements = new ArrayList<Element>();
        this.collectAllElements(this.document, elements);
        for (Element created : this.createdElements) {
            if (elements.contains(created) || created.getParentNode() != null) continue;
            elements.add(created);
        }
        return elements;
    }

    public List<Binding> getBindings() {
        return this.bindings;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public synchronized String getXml() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (StringWriter sw = new StringWriter();){
                DOMSource xmlSource = new DOMSource(this.document);
                StreamResult result = new StreamResult(sw);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(xmlSource, result);
                return sw.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Document getDocument() {
        return this.document;
    }

    public void bind(String sourceTag, String sourceAttribute, String targetTag, String targetAttribute, boolean many) {
        this.bindings.add(new Binding(sourceTag, sourceAttribute, targetTag, targetAttribute, many));
    }

    public boolean isLoaded() {
        return this.document != null;
    }

    protected Element createInstanceInModel(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        return this.createInstance(type, (Collection)Collections.emptyList());
    }

    public synchronized Element createInstance(String type, Collection<Object> parameters) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        String tagName = null;
        boolean root = false;
        if (ELEMENT_TYPE.equals(type)) {
            tagName = parameters.size() == 1 ? "" + parameters.iterator().next() : DEFAULT_NEW_TAG_NAME;
        } else {
            Object param;
            PlainXmlType plainXmlType = PlainXmlType.parse(type);
            if (plainXmlType != null) {
                tagName = plainXmlType.getTagName();
            }
            if (parameters.size() == 1 && (param = parameters.iterator().next()) instanceof Boolean) {
                root = (Boolean)param;
            }
        }
        Element newElement = this.document.createElement(tagName);
        if (!root) {
            this.createdElements.add(newElement);
        } else {
            this.document.appendChild(newElement);
        }
        return newElement;
    }

    protected synchronized boolean deleteElementInModel(Object instance) throws EolRuntimeException {
        if (!(instance instanceof Element)) {
            return false;
        }
        Element e = (Element)instance;
        if (e.getParentNode() != null) {
            e.getParentNode().removeChild(e);
        }
        this.createdElements.remove(e);
        for (Element child : DomUtil.getChildren(e)) {
            this.deleteElement(child);
        }
        return true;
    }

    public synchronized void collectAllElements(Node root, Collection<Element> elements) {
        if (root instanceof Element) {
            elements.add((Element)root);
        }
        NodeList childNodes = root.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node o = childNodes.item(i);
            if (o instanceof Element) {
                this.collectAllElements((Element)o, elements);
            }
            ++i;
        }
    }

    protected Collection<Element> getAllOfKindFromModel(String type) throws EolModelElementTypeNotFoundException {
        return this.getAllOfTypeFromModel(type);
    }

    protected Collection<Element> getAllOfTypeFromModel(String type) throws EolModelElementTypeNotFoundException {
        if (ELEMENT_TYPE.equals(type)) {
            return this.allContents();
        }
        PlainXmlType plainXmlType = PlainXmlType.parse(type);
        if (plainXmlType == null) {
            throw new EolModelElementTypeNotFoundException(this.getName(), type);
        }
        String tagName = plainXmlType.getTagName();
        ArrayList<Element> allOfType = new ArrayList<Element>();
        for (Element e : this.allContents()) {
            if (!this.tagMatches(e, tagName)) continue;
            allOfType.add(e);
        }
        return allOfType;
    }

    public synchronized boolean tagMatches(Element element, String name) {
        if (element.getTagName().equalsIgnoreCase(name)) {
            return true;
        }
        int colonIndex = element.getTagName().indexOf(":");
        if (colonIndex >= 0) {
            return element.getTagName().substring(colonIndex + 1).equalsIgnoreCase(name);
        }
        return false;
    }

    protected void disposeModel() {
        this.document = null;
        this.xml = null;
    }

    public Object getElementById(String id) {
        for (Object o : this.allContents()) {
            Element e = (Element)o;
            if (!e.hasAttribute(this.idAttributeName) || !e.getAttribute(this.idAttributeName).equals(id)) continue;
            return e;
        }
        return null;
    }

    public String getElementId(Object instance) {
        Element element;
        if (instance instanceof Element && (element = (Element)instance).hasAttribute(this.idAttributeName)) {
            return element.getAttribute(this.idAttributeName);
        }
        return null;
    }

    public void setElementId(Object instance, String newId) {
    }

    public void setIdAttributeName(String idAttributeName) {
        this.idAttributeName = idAttributeName;
    }

    public String getIdAttributeName() {
        return this.idAttributeName;
    }

    public Object getEnumerationValue(String enumeration, String label) throws EolEnumerationValueNotFoundException {
        return null;
    }

    public String getTypeNameOf(Object instance) {
        if (instance instanceof Element) {
            return "t_" + ((Element)instance).getTagName();
        }
        return instance.getClass().getName();
    }

    protected Object getCacheKeyForType(String type) throws EolModelElementTypeNotFoundException {
        return type;
    }

    protected Collection<String> getAllTypeNamesOf(Object instance) {
        return Collections.singleton(this.getTypeNameOf(instance));
    }

    public Object getTypeOf(Object instance) {
        return instance.getClass();
    }

    public boolean hasType(String type) {
        return ELEMENT_TYPE.equals(type) || PlainXmlType.parse(type) != null;
    }

    public boolean isInstantiable(String type) {
        return this.hasType(type);
    }

    public boolean isModelElement(Object instance) {
        return instance instanceof Element;
    }

    protected synchronized void loadModel() throws EolModelLoadingException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.document = this.readOnLoad ? (this.file != null ? documentBuilder.parse(this.file) : (this.uri != null ? documentBuilder.parse(this.uri) : documentBuilder.parse(new ByteArrayInputStream(this.xml.getBytes())))) : documentBuilder.newDocument();
        }
        catch (Exception ex) {
            throw new EolModelLoadingException(ex, (IModel)this);
        }
    }

    public void load(StringProperties properties, IRelativePathResolver resolver) throws EolModelLoadingException {
        super.load(properties, resolver);
        String filePath = properties.getProperty(PROPERTY_FILE);
        if (!StringUtil.isEmpty((String)filePath)) {
            this.file = new File(resolver != null ? resolver.resolve(filePath) : filePath);
        } else {
            this.uri = properties.getProperty(PROPERTY_URI);
        }
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean owns(Object instance) {
        if (!(instance instanceof Element)) {
            return false;
        }
        PlainXmlModel plainXmlModel = this;
        synchronized (plainXmlModel) {
            Element e = (Element)instance;
            Node parent = e.getParentNode();
            if (parent == null) {
                return this.createdElements.contains(instance);
            }
            while (true) {
                if (parent.getParentNode() == null) {
                    if (parent == this.document) return true;
                    if (this.createdElements.contains(parent)) return true;
                    return false;
                }
                parent = parent.getParentNode();
            }
        }
    }

    public synchronized boolean store(String location) {
        try {
            DOMSource xmlSource = new DOMSource(this.document);
            StreamResult result = new StreamResult(new FileOutputStream(location));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlSource, result);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean store() {
        if (this.file != null) {
            return this.store(this.file.getAbsolutePath());
        }
        return this.store(this.uri);
    }

    public OperationContributor getOperationContributor() {
        return this.operationContributor;
    }
}

