/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.plainxml;

import org.eclipse.epsilon.emc.plainxml.PlainXmlPropertyDataType;
import org.eclipse.epsilon.emc.plainxml.PlainXmlPropertyType;

public class PlainXmlProperty {
    protected boolean many;
    protected PlainXmlPropertyType type;
    protected String property;
    protected PlainXmlPropertyDataType dataType;

    public static PlainXmlProperty parse(String property) {
        PlainXmlProperty p = new PlainXmlProperty();
        if (property.startsWith("a_") || property.startsWith("b_") || property.startsWith("i_") || property.startsWith("f_") || property.startsWith("d_") || property.startsWith("s_")) {
            p.dataType = p.dataTypeFor(String.valueOf(property.charAt(0)));
            p.type = PlainXmlPropertyType.Attribute;
            p.many = false;
        } else if (property.startsWith("e_")) {
            p.type = PlainXmlPropertyType.Element;
            p.many = false;
        } else if (property.startsWith("c_")) {
            p.type = PlainXmlPropertyType.Element;
            p.many = true;
        } else if (property.startsWith("x_")) {
            p.type = PlainXmlPropertyType.Reference;
        } else {
            p = null;
        }
        if (p != null) {
            p.property = property.substring(2);
        }
        return p;
    }

    public Object cast(String value) {
        value = value.trim();
        if (this.dataType == PlainXmlPropertyDataType.BOOLEAN) {
            return Boolean.parseBoolean(value);
        }
        if (this.dataType == PlainXmlPropertyDataType.INTEGER) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        }
        if (this.dataType == PlainXmlPropertyDataType.FLOAT) {
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException ex) {
                return Float.valueOf(0.0f);
            }
        }
        if (this.dataType == PlainXmlPropertyDataType.DOUBLE) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException ex) {
                return 0.0;
            }
        }
        return value;
    }

    private PlainXmlPropertyDataType dataTypeFor(String letter) {
        if (letter.equals("b")) {
            return PlainXmlPropertyDataType.BOOLEAN;
        }
        if (letter.equals("f")) {
            return PlainXmlPropertyDataType.FLOAT;
        }
        if (letter.equals("d")) {
            return PlainXmlPropertyDataType.DOUBLE;
        }
        if (letter.equals("i")) {
            return PlainXmlPropertyDataType.INTEGER;
        }
        return PlainXmlPropertyDataType.STRING;
    }

    public String getProperty() {
        return this.property;
    }

    public boolean isAttribute() {
        return this.type == PlainXmlPropertyType.Attribute;
    }

    public boolean isElement() {
        return this.type == PlainXmlPropertyType.Element;
    }

    public boolean isMany() {
        return this.many;
    }

    public boolean isReference() {
        return this.type == PlainXmlPropertyType.Reference;
    }
}

