/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.plainxml;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.epsilon.emc.plainxml.Binding;
import org.eclipse.epsilon.emc.plainxml.BindingMatcher;
import org.eclipse.epsilon.emc.plainxml.DomUtil;
import org.eclipse.epsilon.emc.plainxml.LoudList;
import org.eclipse.epsilon.emc.plainxml.PlainXmlModel;
import org.eclipse.epsilon.emc.plainxml.PlainXmlProperty;
import org.eclipse.epsilon.emc.plainxml.TagMatcher;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.java.JavaPropertyGetter;
import org.w3c.dom.Element;

public class PlainXmlPropertyGetter
extends JavaPropertyGetter {
    protected PlainXmlModel model;

    public PlainXmlPropertyGetter(PlainXmlModel model) {
        this.model = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object object, String property, IEolContext context) throws EolRuntimeException {
        if (object instanceof Element) {
            PlainXmlModel plainXmlModel = this.model;
            synchronized (plainXmlModel) {
                block25: {
                    Element e;
                    block24: {
                        e = (Element)object;
                        if ("children".equals(property)) {
                            return DomUtil.getChildren(e);
                        }
                        if ("text".equals(property)) {
                            return e.getTextContent();
                        }
                        if ("name".equals(property)) {
                            int colonIndex = e.getTagName().indexOf(":");
                            if (colonIndex >= 0) {
                                return e.getTagName().substring(colonIndex + 1);
                            }
                            return e.getTagName();
                        }
                        if ("descendants".equals(property)) {
                            return this.getDescendants(e, new ArrayList<Element>());
                        }
                        if (!"parent".equals(property)) break block24;
                        if (e.getParentNode() instanceof Element) {
                            return e.getParentNode();
                        }
                        return null;
                    }
                    if ("tagName".equals(property)) {
                        return e.getTagName();
                    }
                    PlainXmlProperty p = PlainXmlProperty.parse(property);
                    if (p == null) break block25;
                    if (p.isAttribute()) {
                        return p.cast(e.getAttribute(p.getProperty()));
                    }
                    if (p.isReference()) {
                        for (Binding binding : BindingMatcher.getMatchingBindings(this.model, e, p.getProperty())) {
                            if (binding.isMany()) {
                                LoudList<Element> referenced = new LoudList<Element>();
                                String[] referencedIds = e.getAttribute(p.getProperty()).split(",");
                                for (Object o : this.model.allContents()) {
                                    Element candidate = (Element)o;
                                    if (!TagMatcher.matches(candidate, binding.getTargetTag())) continue;
                                    String[] stringArray = referencedIds;
                                    int n = referencedIds.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String referencedId = stringArray[n2];
                                        if (candidate.getAttribute(binding.getTargetAttribute()).equals(referencedId.trim())) {
                                            referenced.add(candidate);
                                        }
                                        ++n2;
                                    }
                                }
                                referenced.addListener(list -> {
                                    String bindTarget = binding.getTargetAttribute();
                                    String newAttributeValue = list.stream().map(element -> element.getAttribute(bindTarget)).collect(Collectors.joining(", "));
                                    e.setAttribute(binding.getSourceAttribute(), newAttributeValue);
                                });
                                return referenced;
                            }
                            String referencedId = e.getAttribute(p.getProperty());
                            for (Object o : this.model.allContents()) {
                                Element candidate = (Element)o;
                                if (!candidate.getTagName().matches(binding.getTargetTag()) || !candidate.getAttribute(binding.getTargetAttribute()).equals(referencedId.trim())) continue;
                                return candidate;
                            }
                        }
                        break block25;
                    }
                    List<Element> children = DomUtil.getChildren(e);
                    ArrayList<Element> result = new ArrayList<Element>();
                    for (Element child : children) {
                        if (!this.model.tagMatches(child, p.getProperty())) continue;
                        result.add(child);
                    }
                    if (p.isMany()) {
                        return result;
                    }
                    if (result.size() > 0) {
                        return result.get(0);
                    }
                    return null;
                }
            }
        }
        return super.invoke(object, property, context);
    }

    protected List<Element> getDescendants(Element root, List<Element> descendants) {
        for (Element child : DomUtil.getChildren(root)) {
            descendants.add(child);
            this.getDescendants(child, descendants);
        }
        return descendants;
    }
}

