/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.plainxml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.epsilon.emc.plainxml.Binding;
import org.eclipse.epsilon.emc.plainxml.PlainXmlModel;
import org.eclipse.epsilon.emc.plainxml.PlainXmlProperty;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.java.JavaPropertySetter;
import org.eclipse.epsilon.eol.execute.operations.contributors.IterableOperationContributor;
import org.w3c.dom.Element;

public class PlainXmlPropertySetter
extends JavaPropertySetter {
    protected PlainXmlModel model;

    public PlainXmlPropertySetter(PlainXmlModel model) {
        this.model = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void invoke(Object object, String property, Object value, IEolContext context) throws EolRuntimeException {
        if (object instanceof Element) {
            PlainXmlModel plainXmlModel = this.model;
            synchronized (plainXmlModel) {
                Element e = (Element)object;
                if ("text".equals(property)) {
                    e.setTextContent(String.valueOf(value));
                    return;
                }
                PlainXmlProperty p = PlainXmlProperty.parse(property);
                if (p != null) {
                    if (p.isAttribute()) {
                        e.setAttribute(p.getProperty(), "" + p.cast(String.valueOf(value)));
                        return;
                    }
                    if (p.isReference()) {
                        String sourceTag = e.getTagName();
                        for (Binding binding : this.model.getBindings()) {
                            String referenceId;
                            Element candidate;
                            if (!sourceTag.matches(binding.getSourceTag()) || !p.getProperty().matches(binding.getSourceAttribute())) continue;
                            String sourceAttribute = p.getProperty();
                            if (binding.isMany()) {
                                ArrayList<String> referenceIds = new ArrayList<String>();
                                ArrayList<Object> values = null;
                                if (value instanceof Collection) {
                                    values = (ArrayList<Object>)value;
                                } else {
                                    values = new ArrayList<Object>();
                                    values.add(value);
                                }
                                for (Object throwable : values) {
                                    String referenceId2;
                                    Element candidate2 = (Element)throwable;
                                    if (!candidate2.getTagName().matches(binding.getTargetTag()) || (referenceId2 = candidate2.getAttribute(binding.getTargetAttribute())) == null || referenceId2.trim().isEmpty()) continue;
                                    referenceIds.add(referenceId2);
                                }
                                Throwable throwable = null;
                                Iterator iterator = null;
                                try (IterableOperationContributor ic = new IterableOperationContributor(referenceIds);){
                                    e.setAttribute(sourceAttribute, ic.concat(", "));
                                    return;
                                }
                                catch (Throwable throwable2) {
                                    void var14_20;
                                    if (throwable == null) {
                                        Throwable throwable3 = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw var14_20;
                                }
                            }
                            if (!(value instanceof Element) || !(candidate = (Element)value).getTagName().matches(binding.getTargetTag()) || (referenceId = candidate.getAttribute(binding.getTargetAttribute())) == null || referenceId.trim().length() <= 0) continue;
                            e.setAttribute(sourceAttribute, referenceId);
                            return;
                        }
                    }
                }
            }
        }
        super.invoke(object, property, value, context);
    }
}

