/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.TreeAdaptor;
import org.eclipse.epsilon.common.module.AbstractModuleElement;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.common.parse.EpsilonTreeAdaptor;
import org.eclipse.epsilon.common.parse.Lexer;
import org.eclipse.epsilon.common.parse.Position;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.eol.util.ReflectionUtil;

public abstract class AbstractModule
extends AbstractModuleElement
implements IModule {
    protected EpsilonParser parser;
    protected ArrayList<ParseProblem> parseProblems = new ArrayList();
    protected File sourceFile;
    protected URI sourceUri;

    public abstract String getMainRule();

    protected abstract org.antlr.runtime.Lexer createLexer(ANTLRInputStream var1);

    public abstract EpsilonParser createParser(TokenStream var1);

    public File getSourceFile() {
        return this.sourceFile;
    }

    public URI getSourceUri() {
        return this.sourceUri;
    }

    public List<ParseProblem> getParseProblems() {
        return this.parseProblems;
    }

    public boolean parse(String code, File file) throws Exception {
        this.sourceFile = file;
        if (file != null) {
            this.sourceUri = file.toURI();
        }
        return this.parse(this.sourceUri, new ByteArrayInputStream(code.getBytes()));
    }

    public boolean parse(URI uri) throws Exception {
        this.sourceUri = uri;
        String uriScheme = uri.getScheme();
        if ("file".equals(uriScheme)) {
            this.sourceFile = new File(uri);
        }
        return this.parse(uri, uri.toURL().openStream());
    }

    protected boolean invokeMainRule(List<CommonToken> comments) throws Exception {
        AST cst = null;
        try {
            cst = (AST)((ParserRuleReturnScope)ReflectionUtil.executeMethod((Object)this.parser, this.getMainRule(), new Object[0])).getTree();
        }
        catch (RecognitionException ex) {
            ParseProblem problem = new ParseProblem();
            problem.setLine(ex.line);
            problem.setColumn(ex.charPositionInLine);
            problem.setReason(ex.getMessage());
            this.getParseProblems().add(problem);
        }
        catch (Throwable ex) {
            ParseProblem problem = new ParseProblem();
            Token next = this.parser.input.LT(1);
            problem.setLine(next.getLine());
            problem.setColumn(next.getCharPositionInLine());
            problem.setReason("mismatched input: '" + next.getText() + "'");
            this.getParseProblems().add(problem);
        }
        this.parseProblems.addAll(this.parser.getParseProblems());
        this.assignAnnotations(cst);
        this.assignComments(cst, comments);
        this.createAst(cst, null);
        return this.getParseProblems().isEmpty();
    }

    public ModuleElement createAst(AST cst, ModuleElement parentAst) {
        if (cst == null) {
            return null;
        }
        ModuleElement moduleElement = this.adapt(cst, parentAst);
        if (moduleElement != null) {
            moduleElement.setUri(cst.getUri());
            moduleElement.setModule(cst.getModule());
            moduleElement.setRegion(cst.getRegion());
            moduleElement.build(cst, (IModule)this);
            if (parentAst != null) {
                moduleElement.setParent(parentAst);
            }
        }
        return moduleElement;
    }

    public abstract ModuleElement adapt(AST var1, ModuleElement var2);

    protected List<CommonToken> extractComments(CommonTokenStream stream) {
        ArrayList<CommonToken> comments = new ArrayList<CommonToken>();
        if (stream.size() == 0) {
            stream.toString();
        }
        for (Object t : stream.getTokens()) {
            CommonToken token = (CommonToken)t;
            int type = token.getType();
            if (type != 25 && type != 26) continue;
            comments.add(token);
        }
        return comments;
    }

    private boolean parse(URI uri, InputStream iStream) throws Exception {
        this.parseProblems.clear();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Scanner s = new Scanner(iStream);){
                s.useDelimiter("\\A");
                String contents = s.hasNext() ? s.next() : "";
                ByteArrayInputStream noTabsStream = new ByteArrayInputStream(contents.replaceAll("\t", " ").getBytes());
                org.antlr.runtime.Lexer lexer = this.createLexer(new ANTLRInputStream((InputStream)noTabsStream));
                CommonTokenStream stream = new CommonTokenStream((TokenSource)lexer);
                List<CommonToken> comments = this.extractComments(stream);
                EpsilonTreeAdaptor adaptor = new EpsilonTreeAdaptor(uri, (IModule)this);
                this.parser = this.createParser((TokenStream)stream);
                this.parser.setDeepTreeAdaptor((TreeAdaptor)adaptor);
                this.parser.getParseProblems().addAll(((Lexer)lexer).getParseProblems());
                return this.invokeMainRule(comments);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            this.parseProblems.add(new ParseProblem("Exception during parsing: " + ex.getLocalizedMessage(), 0));
            throw ex;
        }
    }

    protected void assignComments(AST root, List<CommonToken> comments) {
        for (CommonToken comment : comments) {
            this.assignComment(root, comment);
        }
    }

    protected void assignComment(AST root, CommonToken comment) {
        for (AST ast : root.getDescendants()) {
            Position start = ast.getRegion().getStart();
            if (ast.isImaginary() || comment.getLine() > start.getLine() || comment.getCharPositionInLine() > start.getColumn()) continue;
            ast.getCommentTokens().add(comment);
            return;
        }
    }

    protected void assignAnnotations(AST ast) {
        List children = AstUtil.getChildren((AST)ast);
        for (AST child : children) {
            if (child.getType() == 55) {
                AST target = null;
                if (child.getNextSibling() != null) {
                    if (child.getNextSibling().getType() != 67) {
                        target = child.getNextSibling();
                    } else if (child.getNextSibling().getNextSibling() != null) {
                        target = child.getNextSibling().getNextSibling();
                    }
                }
                if (target == null) continue;
                target.setAnnotationsAst(child);
                continue;
            }
            this.assignAnnotations(child);
        }
    }
}

