/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.debug;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.Position;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.debug.BreakpointRequest;
import org.eclipse.epsilon.eol.debug.BreakpointResult;
import org.eclipse.epsilon.eol.debug.IEolDebugger;
import org.eclipse.epsilon.eol.debug.IEpsilonDebugTarget;
import org.eclipse.epsilon.eol.debug.SuspendReason;
import org.eclipse.epsilon.eol.dom.ExecutableBlock;
import org.eclipse.epsilon.eol.dom.Import;
import org.eclipse.epsilon.eol.dom.Operation;
import org.eclipse.epsilon.eol.dom.Statement;
import org.eclipse.epsilon.eol.dom.StatementBlock;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class EolDebugger
implements IEolDebugger {
    private static final Logger LOGGER = Logger.getLogger(EolDebugger.class.getName());
    private Map<String, IModule> uriToModule;
    private IEpsilonDebugTarget target = null;
    protected boolean stepping = false;
    protected ModuleElement currentModuleElement;
    protected ModuleElement stopAfterModuleElement;
    protected Integer stopAfterFrameStackSizeDropsBelow;

    @Override
    public boolean isTerminated() {
        return this.target != null ? this.target.isTerminated() : true;
    }

    @Override
    public void dispose() {
        this.target = null;
    }

    @Override
    public void setTarget(IEpsilonDebugTarget target) {
        this.target = target;
    }

    @Override
    public IEpsilonDebugTarget getTarget() {
        return this.target;
    }

    protected IEolModule getModule() {
        return this.target != null ? this.target.getModule() : null;
    }

    @Override
    public void control(ModuleElement ast, IEolContext context) {
        if (this.target == null || !this.controls(ast)) {
            return;
        }
        this.currentModuleElement = ast;
        try {
            if (this.stepping) {
                this.stepping = false;
                this.target.suspend(ast, SuspendReason.STEP);
            } else if (this.hasBreakpoint(ast)) {
                this.target.suspend(ast, SuspendReason.BREAKPOINT);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        if (this.isTerminated()) {
            return;
        }
    }

    @Override
    public void done(ModuleElement ast, IEolContext context) {
        if (this.stopAfterModuleElement != null && ast == this.stopAfterModuleElement) {
            this.stepping = true;
            this.stopAfterModuleElement = null;
        }
        if (this.stopAfterFrameStackSizeDropsBelow != null && this.frameStackSize() < this.stopAfterFrameStackSizeDropsBelow) {
            this.stepping = true;
            this.stopAfterFrameStackSizeDropsBelow = null;
        }
    }

    @Override
    public void report(IEolContext context) {
    }

    @Override
    public void step() {
        this.stepping = true;
    }

    @Override
    public void stepOver() {
        this.stopAfterModuleElement = this.currentModuleElement;
    }

    @Override
    public void stepReturn() {
        this.stopAfterFrameStackSizeDropsBelow = this.frameStackSize();
    }

    private boolean controls(ModuleElement ast) {
        if (ast.getParent() == null || ast instanceof StatementBlock) {
            return false;
        }
        return this.isStatement(ast) || this.isContainedExpression(ast);
    }

    private int frameStackSize() {
        IEolModule module = this.getModule();
        return module != null ? module.getContext().getFrameStack().getFrames().size() : 0;
    }

    private ModuleElement getGrandparent(ModuleElement ast) {
        return this.getParent(this.getParent(ast));
    }

    private ModuleElement getParent(ModuleElement ast) {
        return ast != null ? ast.getParent() : null;
    }

    private boolean hasBreakpoint(ModuleElement ast) {
        if (this.target != null && this.target.hasBreakpointItself(ast)) {
            return true;
        }
        if (this.isFirstStatement(ast)) {
            return this.hasBreakpoint(this.getGrandparent(ast));
        }
        if (this.isContainedExpression(ast)) {
            return this.hasBreakpoint(this.getParent(ast));
        }
        if (this.isStructuralBlock(this.getParent(ast))) {
            if (this.isExpressionOrStatementBlockContainer(ast)) {
                return this.hasBreakpoint(this.getParent(ast));
            }
            if (this.isStructuralBlock(ast)) {
                return this.hasBreakpoint(this.getParent(ast));
            }
        }
        return false;
    }

    protected boolean isExpressionOrStatementBlockContainer(ModuleElement ast) {
        return ast instanceof Operation || ast instanceof ExecutableBlock;
    }

    protected boolean isStructuralBlock(ModuleElement ast) {
        return false;
    }

    private boolean isContainedExpression(ModuleElement ast) {
        ModuleElement parent = this.getParent(ast);
        if (parent == null) {
            return false;
        }
        return this.isExpressionOrStatementBlockContainer(parent) && parent.getChildren().size() == 1;
    }

    private boolean isFirstStatement(ModuleElement ast) {
        ModuleElement parent = this.getParent(ast);
        if (parent == null) {
            return false;
        }
        if (!(parent instanceof StatementBlock)) {
            return false;
        }
        ModuleElement grandparent = this.getParent(parent);
        if (!this.isExpressionOrStatementBlockContainer(grandparent)) {
            return false;
        }
        return parent.getChildren().get(0) == ast;
    }

    private boolean isStatement(ModuleElement ast) {
        return ast instanceof Statement;
    }

    @Override
    public boolean isStepping() {
        return this.stepping;
    }

    @Override
    public ModuleElement getStopAfterModuleElement() {
        return this.stopAfterModuleElement;
    }

    @Override
    public Integer getStopAfterFrameStackSizeDropsBelow() {
        return this.stopAfterFrameStackSizeDropsBelow;
    }

    @Override
    public BreakpointResult verifyBreakpoint(BreakpointRequest request) {
        try {
            Position actual;
            IModule resolvedModule = this.resolveModule(request.getUriToPathMappings(), request.getPath());
            if (resolvedModule != null && (actual = this.findFirstLineGreaterThanOrEqualTo((ModuleElement)resolvedModule, new Position(request.getLine(), request.getColumn() == null ? 0 : request.getColumn()))) != null) {
                return BreakpointResult.verified(request, resolvedModule, actual.getLine(), actual.getColumn());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to verify breakpoint due to error: " + e.getMessage(), e);
        }
        return BreakpointResult.failed(request);
    }

    protected IModule resolveModule(Map<URI, Path> uriToPathMappings, String argsSourcePath) throws IOException {
        String argsSourceFileURI;
        if (argsSourcePath == null) {
            return null;
        }
        File argsSourceFile = new File(argsSourcePath);
        if (!argsSourceFile.exists()) {
            return null;
        }
        argsSourceFile = argsSourceFile.getCanonicalFile();
        Map<String, IModule> uriToModule = this.getURIToModuleMap();
        IModule resolvedModule = uriToModule.get(argsSourceFileURI = argsSourceFile.toURI().toString());
        if (resolvedModule != null) {
            return resolvedModule;
        }
        for (Map.Entry<URI, Path> e : uriToPathMappings.entrySet()) {
            String mappedUri;
            String baseUri = e.getKey().toString();
            File canonicalFile = e.getValue().toFile().getCanonicalFile();
            String basePath = String.valueOf(canonicalFile.getPath()) + (canonicalFile.isDirectory() ? File.separator : "");
            if (!argsSourcePath.startsWith(basePath) || (resolvedModule = uriToModule.get(mappedUri = String.valueOf(baseUri) + argsSourcePath.substring(basePath.length()))) == null) continue;
            return resolvedModule;
        }
        return null;
    }

    protected synchronized Map<String, IModule> getURIToModuleMap() throws IOException {
        if (this.uriToModule == null) {
            this.uriToModule = new HashMap<String, IModule>();
            IEolModule module = this.getModule();
            if (module != null) {
                this.addAllModules(this.uriToModule, module);
            }
        }
        return this.uriToModule;
    }

    protected void addAllModules(Map<String, IModule> pathToModule, IModule module) throws IOException {
        String moduleURI = null;
        if (module.getFile() != null) {
            moduleURI = module.getFile().getCanonicalFile().toURI().toString();
        } else if (module.getUri() != null) {
            moduleURI = module.getUri().toString();
        }
        if (moduleURI != null && !pathToModule.containsKey(moduleURI)) {
            pathToModule.put(moduleURI, module);
            if (module instanceof IEolModule) {
                for (Import imp : ((IEolModule)module).getImports()) {
                    this.addAllModules(pathToModule, imp.getModule());
                }
            }
        }
    }

    protected Position findFirstLineGreaterThanOrEqualTo(ModuleElement root, Position position) {
        Position rootStartLine = root.getRegion().getStart();
        if (this.controls(root) && !rootStartLine.isBefore(position)) {
            return rootStartLine;
        }
        Position earliestLine = null;
        for (ModuleElement child : root.getChildren()) {
            Position childLine = this.findFirstLineGreaterThanOrEqualTo(child, position);
            if (childLine == null || earliestLine != null && !childLine.isBefore(earliestLine)) continue;
            earliestLine = childLine;
        }
        if (earliestLine != null) {
            return earliestLine;
        }
        if (this.controls(root) && root.getRegion().getEnd().isAfter(position)) {
            return rootStartLine;
        }
        return earliestLine;
    }
}

