/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.epsilon.common.module.AbstractModuleElement;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.Annotation;
import org.eclipse.epsilon.eol.dom.AnnotationBlock;
import org.eclipse.epsilon.eol.dom.ExecutableAnnotation;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.SimpleAnnotation;
import org.eclipse.epsilon.eol.exceptions.EolIllegalReturnException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;

public abstract class AnnotatableModuleElement
extends AbstractModuleElement {
    protected AnnotationBlock annotationBlock;

    public AnnotationBlock getAnnotationBlock() {
        return this.annotationBlock;
    }

    public void setAnnotationBlock(AnnotationBlock annotationBlock) {
        this.annotationBlock = annotationBlock;
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.annotationBlock = (AnnotationBlock)module.createAst(cst.getAnnotationsAst(), (ModuleElement)this);
    }

    public boolean hasAnnotation(String name) {
        return this.getAnnotation(name) != null;
    }

    protected List<Annotation> getAnnotations(String name) {
        if (this.annotationBlock == null) {
            return Collections.emptyList();
        }
        return this.annotationBlock.getAnnotations().stream().filter(annotation -> annotation.getName().equals(name)).collect(Collectors.toList());
    }

    public Annotation getAnnotation(String name) {
        if (this.annotationBlock == null) {
            return null;
        }
        for (Annotation annotation : this.annotationBlock.getAnnotations()) {
            if (!annotation.getName().equals(name)) continue;
            return annotation;
        }
        return null;
    }

    public boolean getBooleanAnnotationValue(String name, IEolContext context) throws EolRuntimeException {
        return this.getBooleanAnnotationValue(name, context, false, true);
    }

    public boolean getBooleanAnnotationValue(String name, IEolContext context, boolean ifNotExists, boolean ifNoValue) throws EolRuntimeException {
        Annotation annotation = this.getAnnotation(name);
        if (annotation == null) {
            return ifNotExists;
        }
        if (!annotation.hasValue()) {
            return ifNoValue;
        }
        Object result = null;
        if (annotation instanceof SimpleAnnotation) {
            result = ((SimpleAnnotation)annotation).getValue();
        } else if (annotation instanceof ExecutableAnnotation) {
            result = ((ExecutableAnnotation)annotation).getValue(context);
        }
        try {
            return Boolean.parseBoolean(result.toString());
        }
        catch (Exception ex) {
            throw new EolIllegalReturnException("Boolean", result, (ModuleElement)annotation, context);
        }
    }

    public boolean getBooleanAnnotationValue(String name, IEolContext context, Variable ... variables) throws EolRuntimeException {
        return this.getBooleanAnnotationValue(name, context, () -> variables);
    }

    public boolean getBooleanAnnotationValue(String name, IEolContext context, Supplier<? extends Variable[]> variables) throws EolRuntimeException {
        Annotation annotation = this.getAnnotation(name);
        if (annotation != null) {
            if (annotation instanceof ExecutableAnnotation && annotation.hasValue()) {
                FrameStack frameStack = context.getFrameStack();
                frameStack.enterLocal(FrameType.PROTECTED, (ModuleElement)annotation, variables != null ? variables.get() : new Variable[]{});
                Object result = annotation.getValue(context);
                frameStack.leaveLocal((ModuleElement)annotation);
                return result instanceof Boolean && (Boolean)result != false;
            }
            return true;
        }
        return false;
    }

    public List<Object> getAnnotationsValues(String name, IEolContext context) throws EolRuntimeException {
        List<Annotation> annotations = this.getAnnotations(name);
        ArrayList<Object> values = new ArrayList<Object>(annotations.size());
        for (Annotation annotation : annotations) {
            values.add(annotation.getValue(context));
        }
        return values;
    }

    public void accept(IEolVisitor visitor) {
    }
}

