/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.List;
import java.util.Map;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.DivOperatorExpression;
import org.eclipse.epsilon.eol.dom.ElvisOperatorExpression;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.ItemSelectorExpression;
import org.eclipse.epsilon.eol.dom.MinusOperatorExpression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.PlusOperatorExpression;
import org.eclipse.epsilon.eol.dom.PropertyCallExpression;
import org.eclipse.epsilon.eol.dom.Statement;
import org.eclipse.epsilon.eol.dom.TimesOperatorExpression;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;

public class AssignmentStatement
extends Statement {
    protected Expression targetExpression;
    protected Expression valueExpression;

    public AssignmentStatement() {
    }

    public AssignmentStatement(Expression targetExpression, Expression valueExpression) {
        this.targetExpression = targetExpression;
        this.valueExpression = valueExpression;
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.targetExpression = (Expression)module.createAst(cst.getFirstChild(), (ModuleElement)this);
        this.valueExpression = this.getValueExpression(cst, (Expression)module.createAst(cst.getSecondChild(), (ModuleElement)this));
    }

    protected Expression getValueExpression(AST cst, Expression expression) {
        switch (cst.getText()) {
            case "+=": {
                return new PlusOperatorExpression(this.targetExpression, expression);
            }
            case "-=": {
                return new MinusOperatorExpression(this.targetExpression, expression);
            }
            case "/=": {
                return new DivOperatorExpression(this.targetExpression, expression);
            }
            case "*=": {
                return new TimesOperatorExpression(this.targetExpression, expression);
            }
            case "?=": {
                return new ElvisOperatorExpression(this.targetExpression, expression);
            }
        }
        return expression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object execute(IEolContext context) throws EolRuntimeException {
        Object targetExpressionResult;
        Object valueExpressionResult;
        ExecutorFactory executorFactory = context.getExecutorFactory();
        if (this.targetExpression instanceof PropertyCallExpression) {
            PropertyCallExpression pce = (PropertyCallExpression)this.targetExpression;
            Object source = executorFactory.execute(pce.getTargetExpression(), context);
            String property = pce.getName();
            IPropertySetter setter = context.getIntrospectionManager().getPropertySetterFor(source, property, context);
            valueExpressionResult = executorFactory.execute(this.valueExpression, context);
            Object value = this.getValueEquivalent(source, valueExpressionResult, context);
            try {
                setter.invoke(source, property, value, context);
                return valueExpressionResult;
            }
            catch (EolRuntimeException eox) {
                if (eox.getAst() != null) throw eox;
                eox.setAst(this);
                throw eox;
            }
        }
        if (this.targetExpression instanceof ItemSelectorExpression) {
            ItemSelectorExpression ise = (ItemSelectorExpression)this.targetExpression;
            Object source = executorFactory.execute(ise.getTargetExpression(), context);
            Object index = executorFactory.execute(ise.getIndexExpression(), context);
            valueExpressionResult = executorFactory.execute(this.valueExpression, context);
            Object value = this.getValueEquivalent(source, valueExpressionResult, context);
            if (source instanceof List) {
                if (!(index instanceof Integer)) {
                    throw new EolRuntimeException("Collection index must be an integer but " + index + " was provided instead.", ise.getIndexExpression());
                }
                ((List)source).set((Integer)index, value);
                return valueExpressionResult;
            } else {
                if (!(source instanceof Map)) throw new EolRuntimeException(source + " is not a list or a map.", ise.getTargetExpression());
                ((Map)source).put(index, value);
            }
            return valueExpressionResult;
        }
        if (this.targetExpression instanceof NameExpression) {
            NameExpression ne = (NameExpression)this.targetExpression;
            targetExpressionResult = ne.execute(context, true);
        } else {
            targetExpressionResult = executorFactory.execute(this.targetExpression, context);
        }
        if (!(targetExpressionResult instanceof Variable)) throw new EolRuntimeException("Internal error. Expected either a SetterMethod or a Variable and got an " + targetExpressionResult + " instead", this);
        Variable variable = (Variable)targetExpressionResult;
        valueExpressionResult = executorFactory.execute(this.valueExpression, context);
        try {
            Object value = this.getValueEquivalent(variable.getValue(), valueExpressionResult, context);
            variable.setValue(value, context);
            return valueExpressionResult;
        }
        catch (EolRuntimeException ex) {
            ex.setAst(this.targetExpression);
            throw ex;
        }
    }

    protected Object getValueEquivalent(Object source, Object value, IEolContext context) throws EolRuntimeException {
        return value;
    }

    public Expression getTargetExpression() {
        return this.targetExpression;
    }

    public void setTargetExpression(Expression targetExpression) {
        this.targetExpression = targetExpression;
    }

    public Expression getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(Expression valueExpression) {
        this.valueExpression = valueExpression;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

