/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.Iterator;
import java.util.List;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.dom.Statement;
import org.eclipse.epsilon.eol.dom.StatementBlock;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.Break;
import org.eclipse.epsilon.eol.execute.Continue;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.eol.types.EolPrimitiveType;
import org.eclipse.epsilon.eol.types.EolType;

public class ForStatement
extends Statement {
    protected Parameter iteratorParameter;
    protected Expression iteratedExpression;
    protected StatementBlock bodyStatementBlock;

    public ForStatement() {
    }

    public ForStatement(Parameter iteratorParameter, Expression iteratedExpression, StatementBlock bodyStatementBlock) {
        this.iteratorParameter = iteratorParameter;
        this.iteratedExpression = iteratedExpression;
        this.bodyStatementBlock = bodyStatementBlock;
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.iteratorParameter = (Parameter)module.createAst(cst.getFirstChild(), (ModuleElement)this);
        this.iteratedExpression = (Expression)module.createAst(cst.getSecondChild(), (ModuleElement)this);
        this.bodyStatementBlock = this.toStatementBlock(module.createAst(cst.getThirdChild(), (ModuleElement)this));
    }

    @Override
    public Object execute(IEolContext context) throws EolRuntimeException {
        List col;
        ExecutorFactory executorFactory = context.getExecutorFactory();
        Object iteratedObject = executorFactory.execute(this.iteratedExpression, context);
        Iterator<Object> iterator = null;
        if (iteratedObject instanceof Iterator) {
            iterator = (Iterator)iteratedObject;
        } else if (iteratedObject instanceof Iterable) {
            iterator = ((Iterable)iteratedObject).iterator();
        } else if (iteratedObject instanceof EolModelElementType) {
            col = CollectionUtil.createDefaultList();
            col.addAll(((EolModelElementType)iteratedObject).all());
            iterator = col.iterator();
        } else {
            col = CollectionUtil.createDefaultList();
            col.add(iteratedObject);
            iterator = col.iterator();
        }
        EolType iteratorType = this.iteratorParameter.getType(context);
        FrameStack frameStack = context.getFrameStack();
        int loop = 1;
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!iteratorType.isKind(next)) continue;
            frameStack.enterLocal(FrameType.UNPROTECTED, (ModuleElement)this, new Variable(this.iteratorParameter.getName(), next, iteratorType), new Variable("hasMore", iterator.hasNext(), EolPrimitiveType.Boolean, true), new Variable("loopCount", loop++, EolPrimitiveType.Integer, true));
            Object result = null;
            result = executorFactory.execute(this.bodyStatementBlock, context);
            frameStack.leaveLocal(this);
            if (result instanceof Return) {
                return (Return)result;
            }
            if (result instanceof Break) {
                if (!frameStack.isInLoop() || !((Break)result).isAll()) break;
                return result;
            }
            if (!(result instanceof Continue)) continue;
        }
        return null;
    }

    public Expression getIteratedExpression() {
        return this.iteratedExpression;
    }

    public void setIteratedExpression(Expression iteratedExpression) {
        this.iteratedExpression = iteratedExpression;
    }

    public Parameter getIteratorParameter() {
        return this.iteratorParameter;
    }

    public void setIteratorParameter(Parameter iteratorParameter) {
        this.iteratorParameter = iteratorParameter;
    }

    public StatementBlock getBodyStatementBlock() {
        return this.bodyStatementBlock;
    }

    public void setBodyStatementBlock(StatementBlock bodyStatementBlock) {
        this.bodyStatementBlock = bodyStatementBlock;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

