/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.Statement;
import org.eclipse.epsilon.eol.dom.StatementBlock;
import org.eclipse.epsilon.eol.exceptions.EolIllegalReturnException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;

public class IfStatement
extends Statement {
    protected Expression conditionExpression;
    protected StatementBlock thenStatementBlock;
    protected StatementBlock elseStatementBlock;

    public IfStatement() {
    }

    public IfStatement(Expression conditionExpression, StatementBlock thenStatementBlock, StatementBlock elseStatementBlock) {
        this.conditionExpression = conditionExpression;
        this.thenStatementBlock = thenStatementBlock;
        this.elseStatementBlock = elseStatementBlock;
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.conditionExpression = (Expression)module.createAst(cst.getFirstChild(), (ModuleElement)this);
        this.thenStatementBlock = this.toStatementBlock(module.createAst(cst.getSecondChild(), (ModuleElement)this));
        if (cst.getChildCount() == 3) {
            this.elseStatementBlock = this.toStatementBlock(module.createAst(cst.getThirdChild(), (ModuleElement)this));
        }
    }

    @Override
    public Object execute(IEolContext context) throws EolRuntimeException {
        FrameStack frameStack = context.getFrameStack();
        ExecutorFactory executorFactory = context.getExecutorFactory();
        frameStack.enterLocal(FrameType.UNPROTECTED, (ModuleElement)this, new Variable[0]);
        Object condition = executorFactory.execute(this.conditionExpression, context);
        if (!(condition instanceof Boolean)) {
            throw new EolIllegalReturnException("Boolean", condition, this.conditionExpression, context);
        }
        Object result = null;
        if (((Boolean)condition).booleanValue()) {
            result = executorFactory.execute(this.thenStatementBlock, context);
        } else if (this.elseStatementBlock != null) {
            result = executorFactory.execute(this.elseStatementBlock, context);
        }
        frameStack.leaveLocal(this);
        return result;
    }

    public Expression getConditionExpression() {
        return this.conditionExpression;
    }

    public void setConditionExpression(Expression conditionExpression) {
        this.conditionExpression = conditionExpression;
    }

    public StatementBlock getThenStatementBlock() {
        return this.thenStatementBlock;
    }

    public void setThenStatementBlock(StatementBlock thenStatementBlock) {
        this.thenStatementBlock = thenStatementBlock;
    }

    public StatementBlock getElseStatementBlock() {
        return this.elseStatementBlock;
    }

    public void setElseStatementBlock(StatementBlock elseStatementBlock) {
        this.elseStatementBlock = elseStatementBlock;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

