/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.io.File;
import java.net.URI;
import java.util.Objects;
import org.eclipse.epsilon.common.module.AbstractModuleElement;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.UriUtil;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.StringLiteral;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class Import
extends AbstractModuleElement {
    private IEolModule parentModule;
    private IModule importedModule;
    private boolean loaded = false;
    private boolean found = false;
    protected StringLiteral pathLiteral;

    public IEolModule getParentModule() {
        return this.parentModule;
    }

    public void setParentModule(IEolModule parentModule) {
        this.parentModule = parentModule;
    }

    public void setImportedModule(IModule importedModule) {
        this.importedModule = importedModule;
    }

    public IModule getImportedModule() {
        return this.importedModule;
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.pathLiteral = (StringLiteral)module.createAst(cst.getFirstChild(), (ModuleElement)this);
    }

    public void load(URI baseUri) {
        try {
            URI uri;
            File file = new File(this.getPath());
            if (file.isAbsolute()) {
                if (!file.exists()) {
                    return;
                }
                uri = file.toURI();
            } else {
                uri = UriUtil.resolve((String)this.getPath(), (URI[])new URI[]{baseUri});
            }
            IEolModule ancestor = this.parentModule;
            while (ancestor != null && !this.found) {
                if (Objects.equals(ancestor.getSourceUri(), uri)) {
                    this.found = true;
                    this.importedModule = ancestor;
                }
                ancestor = ancestor.getParentModule();
            }
            if (!this.found) {
                try {
                    this.importedModule.parse(uri);
                }
                catch (Exception e) {
                    if ("platform".equals(uri.getScheme()) && uri.getPath().startsWith("/plugin/")) {
                        String sNewURI = uri.toString().replaceFirst("/plugin/", "/resource/");
                        uri = new URI(sNewURI);
                        this.importedModule.parse(uri);
                    }
                    throw e;
                }
            }
            this.found = true;
            this.loaded = this.importedModule.getParseProblems().isEmpty();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return "import '" + this.getPath() + "'";
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public boolean isFound() {
        return this.found;
    }

    public IModule getModule() {
        return this.importedModule;
    }

    public StringLiteral getPathLiteral() {
        return this.pathLiteral;
    }

    public void setPathLiteral(StringLiteral pathLiteral) {
        this.pathLiteral = pathLiteral;
    }

    public String getPath() {
        return (String)this.pathLiteral.getValue();
    }

    public void setContext(IEolContext context) {
        IEolModule module;
        if (this.importedModule instanceof IEolModule && (module = (IEolModule)this.importedModule).getContext() != context) {
            module.setContext(context);
            for (Import import_ : module.getImports()) {
                import_.setContext(context);
            }
        }
    }

    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

