/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.LiteralExpression;

public class IntegerLiteral
extends LiteralExpression<Number> {
    protected String text = "";

    public IntegerLiteral() {
    }

    public IntegerLiteral(Number value) {
        this.setValue(value);
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.setText(cst.getText());
    }

    public void setText(String text) {
        this.text = text;
        if (text.endsWith("l") || text.length() > 10) {
            if (text.endsWith("l")) {
                text = text.substring(0, text.length() - 1);
            }
            this.value = Long.parseLong(text);
        } else {
            try {
                this.value = Integer.parseInt(text);
            }
            catch (NumberFormatException ex) {
                this.value = Long.parseLong(text);
            }
        }
    }

    @Override
    public void setValue(Number value) {
        super.setValue(value);
        this.text = value instanceof Long ? value + "l" : "" + value;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

