/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.LiteralExpression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolMap;
import org.eclipse.epsilon.eol.types.EolTuple;
import org.eclipse.epsilon.eol.types.concurrent.EolConcurrentMap;

public class MapLiteralExpression<K, V>
extends LiteralExpression<Map<K, V>> {
    protected List<Map.Entry<Expression, Expression>> keyValueExpressionPairs = new ArrayList<Map.Entry<Expression, Expression>>();
    protected String mapName;

    public static <K, V> Map<K, V> createMap(String mapName) {
        switch (mapName) {
            case "Map": {
                return new EolMap();
            }
            case "ConcurrentMap": {
                return new EolConcurrentMap();
            }
            case "Tuple": {
                return new EolTuple();
            }
        }
        return null;
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.mapName = cst.getText();
        AST keyvalListAST = cst.getFirstChild();
        if (keyvalListAST != null) {
            for (AST keyValAst : keyvalListAST.getChildren()) {
                this.keyValueExpressionPairs.add(new AbstractMap.SimpleEntry<Expression, Expression>((Expression)module.createAst(keyValAst.getFirstChild(), (ModuleElement)this), (Expression)module.createAst(keyValAst.getSecondChild(), (ModuleElement)this)));
            }
        }
    }

    @Override
    public Map<K, V> execute(IEolContext context) throws EolRuntimeException {
        Map<Object, Object> map = MapLiteralExpression.createMap(this.mapName);
        if (map == null) {
            throw new EolRuntimeException("Unknown map type: " + this.mapName);
        }
        ExecutorFactory executorFactory = context.getExecutorFactory();
        boolean tuple = this.isTuple();
        for (Map.Entry<Expression, Expression> keyValueExpressionPair : this.keyValueExpressionPairs) {
            Expression keyExpr = keyValueExpressionPair.getKey();
            Object key = tuple && keyExpr instanceof NameExpression ? ((NameExpression)keyExpr).getName() : executorFactory.execute(keyExpr, context);
            Object val = executorFactory.execute(keyValueExpressionPair.getValue(), context);
            map.put(key, val);
        }
        return map;
    }

    public boolean isTuple() {
        return "Tuple".equals(this.mapName);
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMapName(String mapName) {
        this.mapName = mapName;
    }

    public List<Map.Entry<Expression, Expression>> getKeyValueExpressionPairs() {
        return this.keyValueExpressionPairs;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

