/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.Expression;

public abstract class OperatorExpression
extends Expression {
    protected Expression firstOperand;
    protected Expression secondOperand;
    protected String operator;

    public OperatorExpression() {
    }

    public OperatorExpression(Expression firstOperand, Expression secondOperand) {
        this.firstOperand = firstOperand;
        this.secondOperand = secondOperand;
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.firstOperand = (Expression)module.createAst(cst.getFirstChild(), (ModuleElement)this);
        this.secondOperand = (Expression)module.createAst(cst.getSecondChild(), (ModuleElement)this);
        this.operator = cst.getText();
    }

    public List<Expression> getOperands() {
        ArrayList<Expression> operands = new ArrayList<Expression>(2);
        operands.add(this.firstOperand);
        if (this.secondOperand != null) {
            operands.add(this.secondOperand);
        }
        return operands;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Expression getFirstOperand() {
        return this.firstOperand;
    }

    public void setFirstOperand(Expression firstOperand) {
        this.firstOperand = firstOperand;
    }

    public Expression getSecondOperand() {
        return this.secondOperand;
    }

    public void setSecondOperand(Expression secondOperand) {
        this.secondOperand = secondOperand;
    }
}

