/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.AssignmentStatement;
import org.eclipse.epsilon.eol.dom.EagerOperatorExpression;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.IntegerLiteral;
import org.eclipse.epsilon.eol.dom.MinusOperatorExpression;
import org.eclipse.epsilon.eol.dom.OperatorExpression;
import org.eclipse.epsilon.eol.dom.PlusOperatorExpression;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class PostfixOperatorExpression
extends OperatorExpression {
    protected boolean increase;
    protected AssignmentStatement assignmentStatement;

    public PostfixOperatorExpression(boolean increase) {
        this.increase = increase;
    }

    public PostfixOperatorExpression(Expression operand, boolean increase) {
        super(operand, null);
        this.increase = increase;
    }

    @Override
    public void build(AST cst, IModule module) {
        super.build(cst, module);
        EagerOperatorExpression valueExpression = null;
        valueExpression = this.increase ? new PlusOperatorExpression(this.firstOperand, new IntegerLiteral(1)) : new MinusOperatorExpression(this.firstOperand, new IntegerLiteral(1));
        this.assignmentStatement = new AssignmentStatement(this.firstOperand, valueExpression);
    }

    @Override
    public Object execute(IEolContext context) throws EolRuntimeException {
        ExecutorFactory executorFactory = context.getExecutorFactory();
        executorFactory.execute(this.assignmentStatement, context);
        return executorFactory.execute(this.firstOperand, context);
    }

    public boolean isIncrease() {
        return this.increase;
    }

    public void setIncrease(boolean increase) {
        this.increase = increase;
    }

    public AssignmentStatement getAssignmentStatement() {
        return this.assignmentStatement;
    }

    public void setAssignmentStatement(AssignmentStatement assignmentStatement) {
        this.assignmentStatement = assignmentStatement;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

