/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.LiteralExpression;

public class RealLiteral
extends LiteralExpression<Number> {
    protected boolean doublePrecision = false;
    private String text = null;

    public RealLiteral() {
    }

    public RealLiteral(Number value) {
        this.setValue(value);
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.setText(cst.getText());
    }

    public void setText(String text) {
        this.text = text;
        if (text.endsWith("f")) {
            text = text.substring(0, text.length() - 1);
            this.doublePrecision = false;
        } else if (text.endsWith("d")) {
            text = text.substring(0, text.length() - 1);
            this.doublePrecision = true;
        } else {
            this.doublePrecision = false;
        }
        this.value = this.doublePrecision ? (Number)Double.valueOf(text) : (Number)Float.valueOf(text);
    }

    @Override
    public void setValue(Number value) {
        super.setValue(value);
        this.text = value instanceof Double ? value + "d" : "" + value;
    }

    public String getText() {
        return this.text;
    }

    public boolean isDoublePrecision() {
        return this.doublePrecision;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

