/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.Statement;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class ReturnStatement
extends Statement {
    protected Expression returnedExpression;

    public ReturnStatement() {
    }

    public ReturnStatement(Expression returnedExpression) {
        this.returnedExpression = returnedExpression;
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.returnedExpression = (Expression)module.createAst(cst.getFirstChild(), (ModuleElement)this);
    }

    @Override
    public Return execute(IEolContext context) throws EolRuntimeException {
        Object result = null;
        if (this.returnedExpression != null) {
            result = context.getExecutorFactory().execute(this.returnedExpression, context);
        }
        return new Return(result);
    }

    public Expression getReturnedExpression() {
        return this.returnedExpression;
    }

    public void setReturnedExpression(Expression returnedExpression) {
        this.returnedExpression = returnedExpression;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

