/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.AbstractExecutableModuleElement;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.ExpressionStatement;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.Statement;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.Break;
import org.eclipse.epsilon.eol.execute.Continue;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class StatementBlock
extends AbstractExecutableModuleElement {
    protected final ArrayList<Statement> statements = new ArrayList();

    public StatementBlock(Statement ... statements) {
        if (statements != null) {
            this.statements.ensureCapacity(statements.length);
            Statement[] statementArray = statements;
            int n = statements.length;
            int n2 = 0;
            while (n2 < n) {
                Statement statement = statementArray[n2];
                if (statement != null) {
                    this.statements.add(statement);
                }
                ++n2;
            }
        }
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        List children = cst.getChildren();
        this.statements.ensureCapacity(this.statements.size() + children.size());
        for (AST ast : children) {
            ModuleElement moduleElement = module.createAst(ast, (ModuleElement)this);
            if (moduleElement instanceof Statement) {
                this.statements.add((Statement)moduleElement);
                continue;
            }
            if (!(moduleElement instanceof Expression)) continue;
            ExpressionStatement expressionStatement = new ExpressionStatement((Expression)moduleElement);
            expressionStatement.setParent(this);
            this.statements.add(expressionStatement);
        }
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    @Override
    public Object execute(IEolContext context) throws EolRuntimeException {
        FrameStack frameStack = context.getFrameStack();
        ExecutorFactory executorFactory = context.getExecutorFactory();
        for (Statement statement : this.statements) {
            frameStack.setCurrentStatement(statement);
            Object result = executorFactory.execute(statement, context);
            if (!(result instanceof Return) && !(result instanceof Break) && !(result instanceof Continue)) continue;
            return result;
        }
        return null;
    }

    public String toString() {
        return "{...}";
    }

    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

