/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.Case;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.Statement;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.Continue;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;

public class SwitchStatement
extends Statement {
    protected Expression conditionExpression;
    protected List<Case> cases = new ArrayList<Case>();
    protected Case _default;

    public SwitchStatement() {
    }

    public SwitchStatement(Expression conditionExpression, List<Case> cases, Case _default) {
        this.conditionExpression = conditionExpression;
        this.cases = cases;
        this._default = _default;
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        for (AST child : cst.getChildren()) {
            ModuleElement moduleElement = module.createAst(child, (ModuleElement)this);
            if (child.getType() == 41) {
                this._default = (Case)moduleElement;
                continue;
            }
            if (child.getType() == 40) {
                this.cases.add((Case)moduleElement);
                continue;
            }
            if (!(moduleElement instanceof Expression)) continue;
            this.conditionExpression = (Expression)moduleElement;
        }
    }

    public List<Case> getCases() {
        return this.cases;
    }

    public Case getDefault() {
        return this._default;
    }

    public Expression getConditionExpression() {
        return this.conditionExpression;
    }

    public void setConditionExpression(Expression conditionExpression) {
        this.conditionExpression = conditionExpression;
    }

    @Override
    public Object execute(IEolContext context) throws EolRuntimeException {
        ExecutorFactory executorFactory = context.getExecutorFactory();
        FrameStack frameStack = context.getFrameStack();
        Object switchValue = executorFactory.execute(this.conditionExpression, context);
        boolean continue_ = false;
        for (Case c : this.cases) {
            frameStack.enterLocal(FrameType.UNPROTECTED, (ModuleElement)c, new Variable[0]);
            try {
                Object caseValue = executorFactory.execute(c.getCondition(), context);
                if (!continue_ && !Objects.equals(switchValue, caseValue)) continue;
                Object result = this.executeCaseBody(c, context, executorFactory);
                if (result instanceof Continue) {
                    continue_ = true;
                    continue;
                }
                Object object = result;
                return object;
            }
            finally {
                frameStack.leaveLocal((ModuleElement)c);
            }
        }
        return this.executeCaseBody(this.getDefault(), context, executorFactory);
    }

    private Object executeCaseBody(Case c, IEolContext context, ExecutorFactory executorFactory) throws EolRuntimeException {
        if (c == null) {
            return null;
        }
        Object result = executorFactory.execute(c.getBody(), context);
        return result instanceof Return || result instanceof Continue ? result : null;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

