/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.Statement;
import org.eclipse.epsilon.eol.dom.StatementBlock;
import org.eclipse.epsilon.eol.exceptions.EolIllegalReturnException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.Break;
import org.eclipse.epsilon.eol.execute.Continue;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;

public class WhileStatement
extends Statement {
    protected Expression conditionExpression;
    protected StatementBlock bodyStatementBlock;

    public WhileStatement() {
    }

    public WhileStatement(Expression conditionExpression, StatementBlock bodyStatementBlock) {
        this.conditionExpression = conditionExpression;
        this.bodyStatementBlock = bodyStatementBlock;
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.conditionExpression = (Expression)module.createAst(cst.getFirstChild(), (ModuleElement)this);
        this.bodyStatementBlock = this.toStatementBlock(module.createAst(cst.getSecondChild(), (ModuleElement)this));
    }

    @Override
    public Object execute(IEolContext context) throws EolRuntimeException {
        FrameStack frameStack = context.getFrameStack();
        ExecutorFactory executorFactory = context.getExecutorFactory();
        int loop = 1;
        while (true) {
            frameStack.enterLocal(FrameType.UNPROTECTED, (ModuleElement)this, new Variable[0]);
            Object condition = executorFactory.execute(this.conditionExpression, context);
            if (!(condition instanceof Boolean)) {
                frameStack.leaveLocal(this);
                throw new EolIllegalReturnException("Boolean", condition, this.conditionExpression, context);
            }
            Object result = null;
            if (!((Boolean)condition).booleanValue()) {
                frameStack.leaveLocal(this);
                break;
            }
            frameStack.put(Variable.createReadOnlyVariable("loopCount", loop));
            result = executorFactory.execute(this.bodyStatementBlock, context);
            frameStack.leaveLocal(this);
            if (result instanceof Return) {
                return result;
            }
            if (result instanceof Break) {
                if (!frameStack.isInLoop() || !((Break)result).isAll()) break;
                return result;
            }
            if (result instanceof Continue) {
                // empty if block
            }
            ++loop;
        }
        return null;
    }

    public Expression getConditionExpression() {
        return this.conditionExpression;
    }

    public void setConditionExpression(Expression conditionExpression) {
        this.conditionExpression = conditionExpression;
    }

    public StatementBlock getBodyStatementBlock() {
        return this.bodyStatementBlock;
    }

    public void setBodyStatementBlock(StatementBlock bodyStatementBlock) {
        this.bodyStatementBlock = bodyStatementBlock;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

