/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.exceptions;

import java.util.Objects;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.prettyprinting.PrettyPrinterManager;
import org.eclipse.epsilon.eol.types.EolNoType;

public class EolIllegalOperationException
extends EolRuntimeException {
    private static final long serialVersionUID = 1418757189757495698L;
    protected String methodName = "";
    protected Object object = null;
    protected PrettyPrinterManager prettyPrintManager;

    public EolIllegalOperationException(Object object, String methodName, ModuleElement ast, PrettyPrinterManager prettyPrintManger) {
        this.ast = ast;
        this.methodName = methodName;
        this.object = object;
        this.prettyPrintManager = prettyPrintManger;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    @Override
    public String getReason() {
        if (this.object == null) {
            return "Called method '" + this.methodName + "' on undefined object";
        }
        String reason = "Method '" + this.methodName + "' not found";
        if (!this.object.equals(EolNoType.NoInstance)) {
            reason = String.valueOf(reason) + " for: ";
            reason = this.prettyPrintManager != null ? String.valueOf(reason) + this.prettyPrintManager.print(this.object) : String.valueOf(reason) + Objects.toString(this.object);
        }
        return reason;
    }
}

