/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.exceptions;

import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class EolIllegalOperationParametersException
extends EolRuntimeException {
    private String method = "";
    private String expected;
    private String actual;

    public EolIllegalOperationParametersException(String method) {
        this.method = method;
    }

    public EolIllegalOperationParametersException(String method, ModuleElement ast) {
        this(method);
        this.ast = ast;
    }

    public EolIllegalOperationParametersException(String method, String expected, ModuleElement ast) {
        this(method, ast);
        this.expected = expected;
    }

    public EolIllegalOperationParametersException(String method, String expected, String actual, ModuleElement ast) {
        this(method, expected, ast);
        this.actual = actual;
    }

    @Override
    public String getReason() {
        String reason = "Invalid number (or types) of arguments for operation '" + this.method + "'";
        if (!StringUtil.isEmpty((String)this.expected)) {
            reason = String.valueOf(reason) + ": expected '" + this.expected + "'";
        }
        if (!StringUtil.isEmpty((String)this.actual)) {
            reason = String.valueOf(reason) + " but got '" + this.actual + "'";
        }
        return reason;
    }

    @Override
    public void setReason(String reason) {
        this.method = reason;
    }
}

