/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import org.eclipse.epsilon.common.module.ModuleElement;

public final class StackTraceManager {
    final Deque<ModuleElement> stackTrace = new ArrayDeque<ModuleElement>();

    protected void dispose() {
        this.stackTrace.clear();
    }

    public List<ModuleElement> getStackTrace() {
        return new ArrayList<ModuleElement>(this.stackTrace);
    }

    public void printStackTrace(PrintWriter writer) {
        writer.print(this.getStackTraceAsString());
    }

    public void printStackTrace(PrintStream stream) {
        stream.print(this.getStackTraceAsString());
    }

    public String getStackTraceAsString() {
        StringBuilder sb = new StringBuilder();
        for (ModuleElement ast : this.getStackTrace()) {
            sb.append(String.valueOf(this.toString(ast)) + System.lineSeparator());
        }
        return sb.toString();
    }

    protected String toString(ModuleElement ast) {
        String location = "unknown";
        if (ast == null) {
            return location;
        }
        if (ast.getFile() != null) {
            location = ast.getFile().getAbsolutePath();
        } else if (ast.getUri() != null) {
            location = ast.getUri().toString();
        }
        return "\tat (" + location + "@" + ast.getRegion().getStart().getLine() + ":" + ast.getRegion().getStart().getColumn() + "-" + ast.getRegion().getEnd().getLine() + ":" + ast.getRegion().getEnd().getColumn() + ")";
    }

    public int hashCode() {
        return Objects.hash(StackTraceManager.class, this.stackTrace);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StackTraceManager)) {
            return false;
        }
        StackTraceManager other = (StackTraceManager)obj;
        return Objects.equals(this.stackTrace, other.stackTrace);
    }
}

