/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.epsilon.common.concurrent.ConcurrentBaseDelegate;
import org.eclipse.epsilon.common.function.BaseDelegate;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.execute.context.Frame;
import org.eclipse.epsilon.eol.execute.context.FrameStackRegion;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.SingleFrame;
import org.eclipse.epsilon.eol.execute.context.Variable;

public class FrameStack
implements Cloneable,
ConcurrentBaseDelegate<FrameStack> {
    protected FrameStackRegion globals;
    protected FrameStackRegion locals;
    protected Map<String, Variable> builtInVariables;
    protected FrameStack base;
    protected boolean isConcurrent;

    public FrameStack() {
        this(null);
    }

    public FrameStack(FrameStack parent) {
        this(parent, false);
    }

    public FrameStack(FrameStack parent, boolean concurrent) {
        this.base = parent;
        this.isConcurrent = concurrent;
        this.globals = new FrameStackRegion(concurrent);
        this.locals = new FrameStackRegion(concurrent);
        this.initializeState();
    }

    protected void initializeState() {
        this.enterGlobal(FrameType.UNPROTECTED, null, new Variable[0]);
        this.builtInVariables = new HashMap<String, Variable>(2);
        this.builtInVariables.put("null", Variable.createReadOnlyVariable("null", null));
    }

    public void dispose() {
        this.globals.dispose();
        this.locals.dispose();
        this.initializeState();
    }

    public Frame enterGlobal(FrameType type, ModuleElement entryPoint, Variable ... variables) {
        return this.globals.enter(type, entryPoint, variables);
    }

    public Frame enterLocal(FrameType type, ModuleElement entryPoint, Variable ... variables) {
        return this.locals.enter(type, entryPoint, variables);
    }

    public Frame enterGlobal(FrameType type, ModuleElement entryPoint, Map<String, ?> variables) {
        return this.globals.enter(type, entryPoint, variables);
    }

    public Frame enterLocal(FrameType type, ModuleElement entryPoint, Map<String, ?> variables) {
        return this.locals.enter(type, entryPoint, variables);
    }

    public void leaveLocal(ModuleElement entryPoint, boolean dispose) {
        this.locals.leave(entryPoint, dispose);
    }

    public void leaveLocal(ModuleElement entryPoint) {
        this.leaveLocal(entryPoint, true);
    }

    public void leaveGlobal(ModuleElement entryPoint, boolean dispose) {
        if (this.countGlobalFrames() > 1) {
            this.globals.leave(entryPoint, dispose);
        }
    }

    public void leaveGlobal(ModuleElement entryPoint) {
        this.leaveGlobal(entryPoint, true);
    }

    public void put(Map<String, ?> variables, boolean readOnly) {
        FrameStackRegion activeRegion = this.activeGroup();
        variables.entrySet().stream().map(entry -> readOnly ? Variable.createReadOnlyVariable(entry) : new Variable((Map.Entry<String, ?>)entry)).forEach(activeRegion::put);
    }

    public void put(Map.Entry<String, ?> variable) {
        if (variable != null) {
            this.put(Variable.createReadOnlyVariable(variable));
        }
    }

    public void put(Collection<Variable> variables) {
        this.activeGroup().put(variables.toArray(new Variable[variables.size()]));
    }

    public void put(Variable ... variables) {
        this.activeGroup().put(variables);
    }

    public void put(String name, Object value) {
        this.activeGroup().put(name, value);
    }

    public void put(Variable variable) {
        this.activeGroup().put(variable);
    }

    public void putGlobal(Variable ... variables) {
        this.globals.put(variables);
    }

    public void putGlobal(Variable variable) {
        this.globals.put(variable);
    }

    public void remove(String variable) {
        this.activeGroup().top().remove(variable);
    }

    public void remove(Collection<String> variables) {
        for (String variable : variables) {
            this.remove(variable);
        }
    }

    public Variable get(String name) {
        Variable variable = this.builtInVariables.get(name);
        if (variable == null) {
            variable = this.getLocal(name);
        }
        if (variable == null) {
            variable = this.getGlobal(name);
        }
        return variable;
    }

    public Variable getLocal(String name) {
        Variable variable = this.locals.get(name);
        if (variable == null && this.base != null) {
            variable = this.base.getLocal(name);
        }
        return variable;
    }

    public Variable getGlobal(String name) {
        Variable variable = this.globals.get(name);
        if (variable == null && this.base != null) {
            variable = this.base.getGlobal(name);
        }
        return variable;
    }

    public boolean isInLoop() {
        return this.locals.isInLoop() || this.globals.isInLoop();
    }

    public boolean contains(String name) {
        return this.get(name) != null;
    }

    public boolean containsLocal(String name) {
        return this.getLocal(name) != null;
    }

    public boolean containsGlobal(String name) {
        return this.getGlobal(name) != null;
    }

    public List<SingleFrame> getFrames() {
        return this.getFrames(false);
    }

    public List<SingleFrame> getFrames(boolean includeBase) {
        ArrayList<SingleFrame> frames = new ArrayList<SingleFrame>();
        frames.addAll(this.locals.getFrames());
        frames.addAll(this.globals.getFrames());
        if (includeBase && this.base != null) {
            frames.addAll(this.base.getFrames(true));
        }
        return frames;
    }

    public int getDepth() {
        return this.locals.frameCount() + this.globals.frameCount();
    }

    public FrameStack clone() {
        FrameStack clone = new FrameStack();
        clone.base = this.base;
        clone.isConcurrent = this.isConcurrent;
        clone.builtInVariables = new HashMap<String, Variable>(this.builtInVariables);
        clone.locals = this.locals.clone();
        clone.globals = this.globals.clone();
        return clone;
    }

    public String toString() {
        return "-----------SCOPE------------\r\n" + this.locals.toString() + "----------GLOBALS-----------\r\n" + this.globals.toString();
    }

    public Frame getTopFrame() {
        return this.activeGroup().top();
    }

    public ModuleElement getCurrentStatement() {
        return this.activeGroup().top().getCurrentStatement();
    }

    public void setCurrentStatement(ModuleElement ast) {
        this.activeGroup().top().setCurrentStatement(ast);
    }

    protected int countGlobalFrames() {
        return this.globals.frameCount();
    }

    private FrameStackRegion activeGroup() {
        return this.locals.isEmpty() ? this.globals : this.locals;
    }

    public void putAll(FrameStack other) {
        this.globals.putAll(other.globals.getAll());
        this.locals.putAll(other.locals.getAll());
        this.builtInVariables.putAll(other.builtInVariables);
    }

    public FrameStack getBase() {
        return this.base;
    }

    public void setBase(FrameStack parent) {
        this.base = parent;
    }

    public int size(boolean includeBase) {
        return this.getFrames(includeBase).size();
    }

    public int size() {
        return this.getFrames().size();
    }

    public boolean isThreadSafe() {
        return this.isConcurrent;
    }

    public void setThreadSafe(boolean concurrent) {
        if (concurrent != this.isConcurrent) {
            this.isConcurrent = concurrent;
            this.locals.setThreadSafe(concurrent);
            this.globals.setThreadSafe(concurrent);
        }
    }

    public void merge(BaseDelegate.MergeMode mode) {
        if (this.base != null) {
            FrameStack.mergeFrameStacks((FrameStack)this.getFrom(mode), (FrameStack)this.getTo(mode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void mergeFrameStacks(FrameStack from, FrameStack to) {
        if (from != null && to != null) {
            FrameStack frameStack = to;
            synchronized (frameStack) {
                FrameStackRegion.mergeFrames(from.locals, to.locals);
                FrameStackRegion.mergeFrames(from.globals, to.globals);
                if (!from.builtInVariables.isEmpty()) {
                    from.builtInVariables.forEach(to.builtInVariables::putIfAbsent);
                }
            }
        }
    }
}

