/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.context;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.execute.context.Frame;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.Variable;

public class SingleFrame
implements Frame,
Cloneable {
    private Map<String, Variable> storage = new LinkedHashMap<String, Variable>(4);
    private FrameType type;
    private String label;
    private ModuleElement entryPoint;
    private ModuleElement currentStatement;

    public SingleFrame(FrameType type, ModuleElement entryPoint) {
        this(type, entryPoint, null);
    }

    public SingleFrame(FrameType type, ModuleElement entryPoint, String label) {
        this.type = type;
        this.entryPoint = entryPoint;
        this.label = label;
    }

    @Override
    public void dispose() {
        for (Variable v : this.storage.values()) {
            v.dispose();
        }
        this.entryPoint = null;
    }

    @Override
    public void clear() {
        this.storage.clear();
        this.currentStatement = null;
    }

    public SingleFrame clone() {
        try {
            SingleFrame clone = (SingleFrame)super.clone();
            clone.storage = new LinkedHashMap<String, Variable>(this.storage.size());
            clone.type = this.type;
            clone.entryPoint = this.entryPoint;
            clone.label = this.label;
            clone.currentStatement = this.currentStatement;
            for (Variable v : this.storage.values()) {
                clone.storage.put(v.name, v.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException cnxx) {
            throw new RuntimeException(cnxx);
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void put(String name, Object value) {
        this.put(Variable.createReadOnlyVariable(name, value));
    }

    @Override
    public void remove(String name) {
        this.storage.remove(name);
    }

    @Override
    public void put(Variable variable) {
        this.storage.put(variable.getName(), variable);
    }

    @Override
    public void putAll(Map<String, Variable> variables) {
        this.storage.putAll(variables);
    }

    @Override
    public Variable get(String key) {
        return this.storage.get(key);
    }

    @Override
    public Map<String, Variable> getAll() {
        return this.storage;
    }

    @Override
    public boolean contains(String key) {
        return this.storage.containsKey(key);
    }

    @Override
    public ModuleElement getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public void setEntryPoint(ModuleElement entryPoint) {
        this.entryPoint = entryPoint;
    }

    @Override
    public FrameType getType() {
        return this.type;
    }

    @Override
    public void setType(FrameType type) {
        this.type = type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("------------" + (Object)((Object)this.type) + "-------------\r\n");
        for (Map.Entry<String, Variable> entry : this.storage.entrySet()) {
            Collection<Variable> nestedVariables;
            Object nested;
            String key = entry.getKey();
            Variable value = entry.getValue();
            Object variableValue = value.getValue();
            if (variableValue instanceof FrameStack ? ((FrameStack)(nested = (FrameStack)variableValue)).getFrames().contains(this) : variableValue instanceof Frame && (nestedVariables = (nested = (Frame)variableValue).getAll().values()).stream().map(Variable::getValue).anyMatch(this::equals)) continue;
            sb.append(String.valueOf(key) + "     " + Objects.toString(value) + "\r\n");
        }
        return sb.toString();
    }

    @Override
    public void setCurrentStatement(ModuleElement ast) {
        this.currentStatement = ast;
    }

    @Override
    public ModuleElement getCurrentStatement() {
        return this.currentStatement;
    }
}

