/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.context.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.concurrent.EolNestedParallelismException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public interface IEolContextParallel
extends IEolContext {
    public static final String NUM_THREADS_CONFIG = "parallelism";
    public static final /* synthetic */ boolean $assertionsDisabled;

    public int getParallelism();

    public void setParallelism(int var1) throws UnsupportedOperationException, IllegalStateException, IllegalArgumentException;

    public boolean isParallel();

    public ExecutorService getExecutorService();

    default public boolean isParallelisationLegal() {
        return !this.isParallel();
    }

    default public void ensureNotNested(ModuleElement entryPoint) throws EolNestedParallelismException {
        if (!this.isParallelisationLegal()) {
            throw new EolNestedParallelismException(entryPoint);
        }
    }

    default public ExecutorService beginParallelTask(ModuleElement entryPoint, boolean canTerminate) throws EolNestedParallelismException {
        this.ensureNotNested((ModuleElement)(entryPoint != null ? entryPoint : this.getModule()));
        ExecutorService executor = this.getExecutorService();
        assert (executor != null && !executor.isShutdown());
        return executor;
    }

    default public ExecutorService beginParallelTask(ModuleElement entryPoint) throws EolNestedParallelismException {
        return this.beginParallelTask(entryPoint, false);
    }

    public void endParallelTask() throws EolRuntimeException;

    default public <T> List<T> executeAll(ModuleElement entryPoint, Collection<? extends Callable<? extends T>> jobs) throws EolRuntimeException {
        ExecutorService executor = this.beginParallelTask(entryPoint);
        ArrayList results = new ArrayList(jobs.size());
        try {
            try {
                for (Future future : executor.invokeAll(jobs)) {
                    results.add(future.get());
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                EolRuntimeException.propagateDetailed(ex);
                assert (false) : "This should never be reached";
                this.endParallelTask();
            }
        }
        finally {
            this.endParallelTask();
        }
        return results;
    }

    default public <T> T executeAny(ModuleElement entryPoint, Collection<? extends Callable<? extends T>> jobs) throws EolRuntimeException {
        T result;
        block2: {
            ExecutorService executor = this.beginParallelTask(entryPoint, true);
            result = null;
            try {
                result = executor.invokeAny(jobs);
            }
            catch (InterruptedException | ExecutionException ex) {
                EolRuntimeException.propagateDetailed(ex);
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"This should never be reached");
            }
        }
        this.endParallelTask();
        return result;
    }

    public static <C extends IEolContextParallel> C configureContext(Map<String, ?> properties, Function<Integer, ? extends C> contextConstructor, C currentContext) throws IllegalArgumentException {
        if (properties.containsKey(NUM_THREADS_CONFIG)) {
            int parallelism = Integer.valueOf(Objects.toString(properties.get(NUM_THREADS_CONFIG)));
            if (parallelism < 1) {
                throw new IllegalArgumentException("Parallelism must be at least 1!");
            }
            return (C)((IEolContextParallel)contextConstructor.apply(parallelism));
        }
        return currentContext;
    }
}

