/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.control;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.util.profiling.BenchmarkUtils;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.control.ExecutionController;
import org.eclipse.epsilon.eol.execute.control.IExecutionListener;

public class ExecutionProfiler
implements ExecutionController,
IExecutionListener {
    protected final Map<ModuleElement, Duration> executionTimes = new HashMap<ModuleElement, Duration>();
    private ModuleElement currentAst;
    private long currentStart;

    protected boolean screenAST(ModuleElement ast, IEolContext context) {
        return true;
    }

    @Override
    public void control(ModuleElement ast, IEolContext context) {
        if (ast != null && this.screenAST(ast, context)) {
            this.currentAst = ast;
            this.currentStart = System.nanoTime();
        }
    }

    @Override
    public void done(ModuleElement ast, IEolContext context) {
        if (ast == null || ast != this.currentAst) {
            return;
        }
        long execTime = System.nanoTime() - this.currentStart;
        Duration currentDuration = this.executionTimes.get(ast);
        this.executionTimes.put(this.currentAst, currentDuration != null ? currentDuration.plusNanos(execTime) : Duration.ofNanos(execTime));
        this.currentAst = null;
    }

    @Override
    public void dispose() {
        this.executionTimes.clear();
        this.currentAst = null;
        this.currentStart = 0L;
    }

    @Override
    public void report(IEolContext context) {
        context.getErrorStream().println(this.toString());
    }

    public String toString() {
        return this.getExecutionTimes().entrySet().stream().sorted((a, b) -> ((Duration)b.getValue()).compareTo((Duration)a.getValue())).map(entry -> "'" + entry.getKey() + "' took " + BenchmarkUtils.formatDuration((Duration)((Duration)entry.getValue()))).collect(Collectors.joining("," + System.lineSeparator()));
    }

    @SafeVarargs
    public final void mergeExecutionTimes(Map<? extends ModuleElement, Duration> ... others) {
        Map<? extends ModuleElement, Duration>[] mapArray = others;
        int n = others.length;
        int n2 = 0;
        while (n2 < n) {
            Map<? extends ModuleElement, Duration> execTimes = mapArray[n2];
            for (Map.Entry<? extends ModuleElement, Duration> entry : execTimes.entrySet()) {
                Duration ruleDuration = this.executionTimes.get(entry.getKey());
                Duration entryDuration = entry.getValue();
                this.executionTimes.put(entry.getKey(), ruleDuration != null ? ruleDuration.plus(entryDuration) : entryDuration);
            }
            ++n2;
        }
    }

    public Map<ModuleElement, Duration> getExecutionTimes() {
        return this.executionTimes;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public void aboutToExecute(ModuleElement ast, IEolContext context) {
        this.control(ast, context);
    }

    @Override
    public void finishedExecuting(ModuleElement ast, Object result, IEolContext context) {
        this.done(ast, context);
    }

    @Override
    public void finishedExecutingWithException(ModuleElement ast, EolRuntimeException exception, IEolContext context) {
        this.done(ast, context);
    }
}

