/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.introspection.java;

import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.AbstractPropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.IReflectivePropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.java.ObjectMethod;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributorRegistry;

public class JavaPropertySetter
extends AbstractPropertySetter
implements IReflectivePropertySetter {
    protected ObjectMethod getMethodFor(Object object, String property, Object value, IEolContext context) {
        OperationContributorRegistry registry = context.getOperationContributorRegistry();
        ObjectMethod om = registry.findContributedMethodForEvaluatedParameters(object, "set" + property, new Object[]{value}, context);
        if (om != null) {
            return om;
        }
        return new ObjectMethod(object);
    }

    @Override
    public void invoke(Object target, String property, Object value, IEolContext context) throws EolRuntimeException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (ObjectMethod objectMethod = this.getMethodFor(target, property, value, context);){
            ModuleElement ast = context.getExecutorFactory().getActiveModuleElement();
            if (objectMethod.method == null) {
                throw new EolIllegalPropertyException(target, property, ast, context);
            }
            objectMethod.execute(ast, context, value);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object coerce(Object target, String property, Object value, IEolContext context) throws EolIllegalPropertyException {
        return value;
    }

    @Override
    public boolean conforms(Object target, String property, Object value, IEolContext context) throws EolIllegalPropertyException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }
}

