/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.introspection.java;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.stream.BaseStream;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.concurrent.EolContextParallel;
import org.eclipse.epsilon.eol.execute.context.concurrent.IEolContextParallel;
import org.eclipse.epsilon.eol.execute.introspection.java.DisposableObject;
import org.eclipse.epsilon.eol.util.ReflectionUtil;

public class ObjectMethod
extends DisposableObject {
    protected Method method;

    public ObjectMethod() {
    }

    public ObjectMethod(Object object) {
        this.object = object;
    }

    public ObjectMethod(Object object, Method method) {
        this.object = object;
        this.method = method;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public final Object execute(ModuleElement ast, Object ... parameters) throws EolRuntimeException {
        return this.execute(parameters, ast);
    }

    public Object execute(Object[] parameters, ModuleElement ast) throws EolRuntimeException {
        if (this.method.isVarArgs()) {
            int varargIndex = this.method.getParameterCount() - 1;
            Object[] adjustedParams = new Object[this.method.getParameterCount()];
            Class<?> varargType = this.method.getParameterTypes()[varargIndex].getComponentType();
            int i = 0;
            while (i < varargIndex) {
                adjustedParams[i] = parameters[i];
                ++i;
            }
            int numberOfVarargs = parameters.length - varargIndex;
            if (numberOfVarargs < 0) {
                numberOfVarargs = 0;
            }
            Object varargParams = Array.newInstance(varargType, numberOfVarargs);
            int i2 = 0;
            while (i2 < numberOfVarargs) {
                Array.set(varargParams, i2, parameters[varargIndex + i2]);
                ++i2;
            }
            adjustedParams[adjustedParams.length - 1] = varargParams;
            parameters = adjustedParams;
        }
        return ReflectionUtil.executeMethod(this.object, this.method, ast, parameters);
    }

    public Object execute(ModuleElement ast, IEolContext context, Object ... parameters) throws EolRuntimeException {
        boolean isParallelOperation;
        boolean bl = isParallelOperation = this.object instanceof BaseStream && ((BaseStream)this.object).isParallel();
        if (isParallelOperation && !BaseStream.class.isAssignableFrom(this.method.getReturnType())) {
            IEolContext pContext = context = EolContextParallel.convertToParallel(context);
            if (pContext.isParallelisationLegal()) {
                pContext.beginParallelTask(ast, true);
            } else {
                ((BaseStream)this.object).sequential();
            }
        }
        Object result = this.execute(parameters, ast);
        if (isParallelOperation && context instanceof IEolContextParallel) {
            IEolContextParallel pContext = (IEolContextParallel)context;
            pContext.endParallelTask();
        }
        return result;
    }
}

