/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.introspection.recording;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.WeakHashMap;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.dom.AssignmentStatement;
import org.eclipse.epsilon.eol.dom.PropertyCallExpression;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.control.IExecutionListener;
import org.eclipse.epsilon.eol.execute.introspection.recording.IPropertyAccessRecorder;

public class PropertyAccessExecutionListener
implements IExecutionListener {
    private final Collection<IPropertyAccessRecorder> recorders = new LinkedList<IPropertyAccessRecorder>();
    private final WeakHashMap<ModuleElement, Object> cache = new WeakHashMap();

    public PropertyAccessExecutionListener(IPropertyAccessRecorder ... recorders) {
        this.recorders.addAll(Arrays.asList(recorders));
    }

    @Override
    public void aboutToExecute(ModuleElement ast, IEolContext context) {
    }

    @Override
    public void finishedExecuting(ModuleElement ast, Object result, IEolContext context) {
        String propertyName;
        PropertyCallExpression propertyCallExpression;
        Object modelElement;
        if (PropertyAccessExecutionListener.isLeftHandSideOfPointExpression(ast)) {
            this.cache.put(ast, result);
        }
        if (PropertyAccessExecutionListener.isPropertyAccessExpression(ast) && PropertyAccessExecutionListener.isModelBasedProperty(modelElement = this.cache.get((propertyCallExpression = (PropertyCallExpression)ast).getTargetExpression()), propertyName = propertyCallExpression.getNameExpression().getName(), context)) {
            for (IPropertyAccessRecorder recorder : this.recorders) {
                recorder.record(modelElement, propertyName);
            }
        }
    }

    @Override
    public void finishedExecutingWithException(ModuleElement ast, EolRuntimeException exception, IEolContext context) {
    }

    private static boolean isLeftHandSideOfPointExpression(ModuleElement ast) {
        return ast.getParent() instanceof PropertyCallExpression && ((PropertyCallExpression)ast.getParent()).getTargetExpression() == ast;
    }

    private static boolean isPropertyAccessExpression(ModuleElement ast) {
        return ast instanceof PropertyCallExpression && !PropertyAccessExecutionListener.isAssignee(ast);
    }

    private static boolean isModelBasedProperty(Object object, String property, IEolContext context) {
        return context.getIntrospectionManager().isModelBasedProperty(object, property, context);
    }

    private static boolean isAssignee(ModuleElement ast) {
        return ast.getParent() instanceof AssignmentStatement && ((AssignmentStatement)ast.getParent()).getTargetExpression() == ast;
    }
}

