/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolIllegalOperationException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.java.ObjectMethod;
import org.eclipse.epsilon.eol.execute.operations.AbstractOperation;
import org.eclipse.epsilon.eol.function.EolLambdaFactory;
import org.eclipse.epsilon.eol.types.EolNoType;
import org.eclipse.epsilon.eol.util.ReflectionUtil;

public class DynamicOperation
extends AbstractOperation {
    @Override
    public Object execute(Object target, NameExpression operationNameExpression, List<Parameter> iterators, List<Expression> expressions, IEolContext context) throws EolRuntimeException {
        assert (expressions != null && !expressions.isEmpty());
        LinkedHashMap<Expression, List<Parameter>> lambdas = new LinkedHashMap<Expression, List<Parameter>>(expressions.size(), 1.0f);
        for (Expression expression : expressions) {
            lambdas.put(expression, iterators);
        }
        return this.execute(target, operationNameExpression, lambdas, context);
    }

    public Object execute(Object target, NameExpression operationNameExpression, LinkedHashMap<Expression, List<Parameter>> lambdas, IEolContext context) throws EolRuntimeException {
        Iterator<Map.Entry<Expression, List<Parameter>>> entriesIter = lambdas.entrySet().iterator();
        Set<Expression> expressions = lambdas.keySet();
        String methodName = operationNameExpression.getName();
        if (target instanceof EolNoType || target instanceof EolLambdaFactory) {
            Map.Entry<Expression, List<Parameter>> first = entriesIter.next();
            return EolLambdaFactory.resolveFor(methodName, first.getValue(), first.getKey(), (ModuleElement)operationNameExpression, context);
        }
        Predicate<Method> criteria = method -> Modifier.isPublic(method.getModifiers()) && method.getParameterCount() == expressions.size() && Arrays.stream(method.getParameterTypes()).filter(Class::isInterface).allMatch(intf -> Arrays.stream(intf.getAnnotations()).anyMatch(a -> a.annotationType().equals(FunctionalInterface.class)) || Arrays.stream(intf.getMethods()).filter(targetParamMethod -> Modifier.isAbstract(targetParamMethod.getModifiers())).count() == 1L);
        Method resolvedMethod = ReflectionUtil.findApplicableMethodOrThrow(target, methodName, criteria, expressions, operationNameExpression, context.getPrettyPrinterManager());
        int candidateParamCount = resolvedMethod.getParameterCount();
        Object[] candidateParameterValues = new Object[candidateParamCount];
        java.lang.reflect.Parameter[] candidateParameterTypes = resolvedMethod.getParameters();
        int i = 0;
        while (i < candidateParamCount && entriesIter.hasNext()) {
            Class<?> targetType = candidateParameterTypes[i].getType();
            Map.Entry<Expression, List<Parameter>> complexExpr = entriesIter.next();
            Expression rawExpr = complexExpr.getKey();
            if (!targetType.isInterface() || complexExpr.getValue() == null) {
                candidateParameterValues[i] = rawExpr.execute(context);
            } else {
                List<Parameter> iteratorParams = DynamicOperation.normalizeParameters(complexExpr.getValue());
                try {
                    candidateParameterValues[i] = EolLambdaFactory.resolveFor(targetType, iteratorParams, rawExpr, (ModuleElement)operationNameExpression, context);
                }
                catch (EolIllegalOperationException eox) {
                    IEolContext fContext = context;
                    candidateParameterValues[i] = Proxy.newProxyInstance(targetType.getClassLoader(), new Class[]{targetType}, (proxy, method, args) -> EolLambdaFactory.executeExpression(fContext, operationNameExpression, null, rawExpr, iteratorParams, args));
                }
            }
            ++i;
        }
        Throwable throwable = null;
        Object var14_17 = null;
        try (ObjectMethod om = new ObjectMethod(target, resolvedMethod);){
            return om.execute((ModuleElement)operationNameExpression, context, candidateParameterValues);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static List<Parameter> normalizeParameters(List<Parameter> iterators) {
        if (iterators != null && iterators.size() == 1 && StringUtil.isOneOf((String)iterators.get(0).getName(), (String[])new String[]{"null", "_"})) {
            return Collections.emptyList();
        }
        return iterators;
    }
}

