/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.contributors;

import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.types.EolSequence;

public class IntegerOperationContributor
extends OperationContributor {
    @Override
    public boolean contributesTo(Object target) {
        return target instanceof Integer;
    }

    @Override
    protected Integer getTarget() {
        return (Integer)super.getTarget();
    }

    public EolSequence<Integer> to(Integer end) {
        int start = this.getTarget();
        EolSequence<Integer> result = new EolSequence<Integer>();
        if (start < end) {
            int cap = end - start;
            if (cap > 0) {
                result.ensureCapacity(cap);
            }
            int i = start;
            while (i <= end) {
                result.add(i);
                ++i;
            }
        } else {
            int cap = start - end;
            if (cap > 0) {
                result.ensureCapacity(cap);
            }
            int i = start;
            while (i >= end) {
                result.add(i);
                --i;
            }
        }
        return result;
    }

    public EolSequence<Integer> iota(int i, int step) throws Exception {
        EolSequence<Integer> result = new EolSequence<Integer>();
        int x = this.getTarget();
        if (step == 0 || x < i && step < 0 || x > i && step > 0) {
            throw new Exception("Invalid argument(s) to iota(i, step)");
        }
        if (step > 0 && i > step) {
            int div = i / step;
            result.ensureCapacity(div + 1);
        }
        while (x <= i) {
            result.add(x);
            x += step;
        }
        return result;
    }

    public String toBinary() {
        return Integer.toBinaryString(this.getTarget());
    }

    public String toHex() {
        return Integer.toHexString(this.getTarget());
    }

    public Integer mod(Integer other) {
        return this.getTarget() % other;
    }
}

