/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.contributors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.types.EolBag;
import org.eclipse.epsilon.eol.types.EolCollectionType;
import org.eclipse.epsilon.eol.types.EolNoType;
import org.eclipse.epsilon.eol.types.EolOrderedSet;
import org.eclipse.epsilon.eol.types.EolSequence;
import org.eclipse.epsilon.eol.types.EolSet;
import org.eclipse.epsilon.eol.types.EolType;
import org.eclipse.epsilon.eol.types.NumberUtil;
import org.eclipse.epsilon.eol.types.concurrent.EolConcurrentBag;
import org.eclipse.epsilon.eol.types.concurrent.EolConcurrentSet;

public class IterableOperationContributor
extends OperationContributor {
    public IterableOperationContributor() {
    }

    public IterableOperationContributor(Iterable<?> target) {
        this.setTarget(target);
    }

    @Override
    protected Iterable<?> getTarget() {
        return (Iterable)super.getTarget();
    }

    protected Iterable<Object> getIterable() {
        return this.getTarget();
    }

    protected boolean isCollection() {
        return this.getTarget() instanceof Collection;
    }

    protected Collection<Object> getCollection() {
        return (Collection)this.getTarget();
    }

    protected boolean isList() {
        return this.getTarget() instanceof List;
    }

    protected List<?> getList() {
        return (List)this.getTarget();
    }

    protected boolean isSet() {
        return this.getTarget() instanceof Set;
    }

    protected Set<?> getSet() {
        return (Set)this.getTarget();
    }

    @Override
    public boolean contributesTo(Object target) {
        return target instanceof Iterable;
    }

    public Object random() {
        if (this.isEmpty()) {
            return null;
        }
        int size = this.size();
        return this.nth(size > 0 ? new Random().nextInt(size) : 0);
    }

    public int size() {
        if (this.isCollection()) {
            return this.getCollection().size();
        }
        int size = 0;
        Iterator it = this.getTarget().iterator();
        while (it.hasNext()) {
            it.next();
            ++size;
        }
        return size;
    }

    public Object at(int index) {
        if (this.isList()) {
            return this.getList().get(index);
        }
        int i = 0;
        Iterator iterator = this.getTarget().iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (i++ != index) continue;
            return next;
        }
        return null;
    }

    public Object removeAt(int index) {
        if (this.isList()) {
            return this.getList().remove(index);
        }
        Object toRemove = null;
        Iterator it = this.getTarget().iterator();
        int i = 0;
        while (it.hasNext() && i <= index) {
            toRemove = it.next();
            ++i;
        }
        if (toRemove != null && i == index + 1) {
            it.remove();
        }
        return toRemove;
    }

    public EolConcurrentBag<Object> asConcurrentBag() {
        EolConcurrentBag<Object> copy = new EolConcurrentBag<Object>();
        this.copy(this.getIterable(), copy);
        return copy;
    }

    public EolConcurrentSet<Object> asConcurrentSet() {
        EolConcurrentSet<Object> copy = new EolConcurrentSet<Object>();
        this.copy(this.getIterable(), copy);
        return copy;
    }

    public EolSequence<Object> asSequence() {
        EolSequence<Object> copy = new EolSequence<Object>();
        this.copy(this.getIterable(), copy);
        return copy;
    }

    public EolSet<Object> asSet() {
        EolSet<Object> copy = new EolSet<Object>();
        this.copy(this.getIterable(), copy);
        return copy;
    }

    public EolBag<Object> asBag() {
        EolBag<Object> copy = new EolBag<Object>();
        this.copy(this.getIterable(), copy);
        return copy;
    }

    public EolOrderedSet<Object> asOrderedSet() {
        EolOrderedSet<Object> copy = new EolOrderedSet<Object>();
        this.copy(this.getIterable(), copy);
        return copy;
    }

    public Number sum() {
        return this.parallelStream().filter(Number.class::isInstance).map(Number.class::cast).reduce(0, (i, sum) -> NumberUtil.add(sum, i));
    }

    public Number product() {
        if (this.isEmpty()) {
            return Float.valueOf(0.0f);
        }
        return this.parallelStream().filter(Number.class::isInstance).map(Number.class::cast).reduce(1, (product, i) -> NumberUtil.multiply(product, i));
    }

    public boolean isEmpty() {
        Object target = this.getTarget();
        if (target instanceof Collection) {
            return ((Collection)target).isEmpty();
        }
        return !this.getTarget().iterator().hasNext();
    }

    public boolean notEmpty() {
        return !this.isEmpty();
    }

    protected <T> void copy(Iterable<T> source, Collection<T> target) {
        Iterator<T> it = source.iterator();
        while (it.hasNext()) {
            target.add(it.next());
        }
    }

    public Stream<?> stream() {
        return this.stream(false);
    }

    public Stream<?> parallelStream() {
        return this.stream(true);
    }

    protected Stream<?> stream(boolean parallel) {
        Object target = this.getTarget();
        if (target instanceof Collection) {
            Collection col = (Collection)target;
            return parallel ? col.parallelStream() : col.stream();
        }
        return StreamSupport.stream(target.spliterator(), parallel);
    }

    public Collection<?> clone() {
        if (this.isCollection()) {
            return EolCollectionType.clone(this.getCollection());
        }
        return null;
    }

    public boolean includes(Object key) {
        if (this.isCollection()) {
            return this.getCollection().contains(key);
        }
        Iterator it = this.getTarget().iterator();
        while (it.hasNext()) {
            if (!Objects.equals(it.next(), key)) continue;
            return true;
        }
        return false;
    }

    public boolean excludes(Object o) {
        return !this.includes(o);
    }

    public boolean includesAll(Collection<?> col) {
        for (Object item : col) {
            if (!this.excludes(item)) continue;
            return false;
        }
        return true;
    }

    public boolean excludesAll(Collection<?> col) {
        for (Object item : col) {
            if (!this.includes(item)) continue;
            return false;
        }
        return true;
    }

    public int count(Object o) {
        return this.stream().filter(item -> Objects.equals(item, o)).mapToInt(item -> 1).sum();
    }

    public Collection<Object> selectByKind(EolType type) {
        if (type == null) {
            type = EolNoType.Instance;
        }
        return this.stream().filter(type::isKind).collect(Collectors.toCollection(this::createCollection));
    }

    public Collection<Object> selectByType(EolType type) {
        if (type == null) {
            type = EolNoType.Instance;
        }
        return this.stream().filter(type::isType).collect(Collectors.toCollection(this::createCollection));
    }

    public Collection<Object> includingAll(Collection<?> col) {
        Collection<Object> result = this.createCollection();
        IterableOperationContributor.addAll(this.getTarget(), result);
        IterableOperationContributor.addAll(col, result);
        return result;
    }

    public Collection<Object> including(Object o) {
        Collection<Object> result = this.createCollection();
        IterableOperationContributor.addAll(this.getTarget(), result);
        result.add(o);
        return result;
    }

    public Collection<Object> flatten() {
        Collection<Object> col;
        if (this.isCollection()) {
            col = this.getCollection();
        } else {
            col = this.createCollection();
            IterableOperationContributor.addAll(this.getTarget(), col);
        }
        return CollectionUtil.flatten(col);
    }

    public Collection<Object> excluding(Object o) {
        Collection<Object> excluding = this.createCollection();
        IterableOperationContributor.addAll(this.getTarget(), excluding);
        while (excluding.contains(o)) {
            excluding.remove(o);
        }
        return excluding;
    }

    public Collection<Object> excludingAll(Collection<?> col) {
        Collection<Object> difference = this.createCollection();
        Iterator iterator = this.getTarget().iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (col.contains(next)) continue;
            difference.add(next);
        }
        return difference;
    }

    public Collection<Object> first(int number) {
        Iterator it = this.getTarget().iterator();
        ArrayList<Object> result = new ArrayList<Object>(number);
        int i = 0;
        while (it.hasNext() && i++ < number) {
            result.add(it.next());
        }
        return result;
    }

    public Object first() {
        return this.nth(0);
    }

    public Object second() {
        return this.nth(1);
    }

    public Object third() {
        return this.nth(2);
    }

    public Object fourth() {
        return this.nth(3);
    }

    public Object last() {
        if (this.isCollection()) {
            return this.nth(this.getCollection().size() - 1);
        }
        Object o = null;
        Iterator it = this.getTarget().iterator();
        while (it.hasNext()) {
            o = it.next();
        }
        return o;
    }

    public int indexOf(Object o) {
        if (this.isList()) {
            return this.getList().indexOf(o);
        }
        int counter = 0;
        Iterator iterator = this.getTarget().iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (Objects.equals(item, o)) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    private Object nth(int index) {
        if (this.isEmpty()) {
            return null;
        }
        return this.at(index);
    }

    public String concat() {
        return this.concat("");
    }

    public String concat(String delimiter) {
        return CollectionUtil.join((Iterable)this.getTarget(), (String)delimiter, element -> Objects.toString(element, ""));
    }

    public Number max() {
        return this.max(0);
    }

    public Number max(Number default_) {
        Number max = null;
        Iterator iterator = this.getTarget().iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof Number)) continue;
            Number nextNumber = (Number)next;
            if (max != null && !NumberUtil.greaterThan(nextNumber, max)) continue;
            max = nextNumber;
        }
        if (max == null) {
            max = default_;
        }
        return max;
    }

    public Number min() {
        return this.min(0);
    }

    public Number min(Number default_) {
        Number min = null;
        Iterator iterator = this.getTarget().iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof Number)) continue;
            Number nextNumber = (Number)next;
            if (min != null && !NumberUtil.lessThan(nextNumber, min)) continue;
            min = nextNumber;
        }
        if (min == null) {
            min = default_;
        }
        return min;
    }

    public Collection<Object> invert() {
        EolSequence<Object> sequence = new EolSequence<Object>();
        Iterator iterator = this.getTarget().iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            sequence.add(0, o);
        }
        return sequence;
    }

    public Collection<Object> createCollection() {
        if (this.isCollection()) {
            return EolCollectionType.createSameType(this.getCollection());
        }
        return new EolSequence<Object>();
    }

    public Set<Set<Object>> powerset() {
        EolSequence<Object> originalSet = this.asSequence();
        HashSet<Set<Object>> sets = new HashSet<Set<Object>>();
        if (originalSet.isEmpty()) {
            sets.add(new HashSet());
            return sets;
        }
        Object head = originalSet.get(0);
        HashSet rest = new HashSet(originalSet.subList(1, originalSet.size()));
        Throwable throwable = null;
        Object var6_7 = null;
        try (IterableOperationContributor restOC = new IterableOperationContributor(rest);){
            for (Set<Object> set : restOC.powerset()) {
                HashSet<Object> newSet = new HashSet<Object>();
                newSet.add(head);
                newSet.addAll(set);
                sets.add(newSet);
                sets.add(set);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return sets;
    }

    private static void addAll(Iterable<?> elements, Collection<Object> target) {
        if (elements instanceof Collection) {
            target.addAll((Collection)elements);
        } else {
            for (Object o : elements) {
                target.add(o);
            }
        }
    }
}

