/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.contributors;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.java.ObjectMethod;
import org.eclipse.epsilon.eol.util.ReflectionUtil;

public abstract class OperationContributor
implements AutoCloseable {
    private final ThreadLocal<Object> target = new ThreadLocal();
    private final ThreadLocal<IEolContext> context = new ThreadLocal();
    protected Set<String> cachedMethodNames;

    public abstract boolean contributesTo(Object var1);

    public ObjectMethod findContributedMethodForUnevaluatedParameters(Object target, String name, List<Expression> parameterExpressions, IEolContext context) {
        return this.createObjectMethodFor(target, name, new Object[]{new AST()}, context, false);
    }

    public ObjectMethod findContributedMethodForEvaluatedParameters(Object target, String name, Object[] parameters, IEolContext context) {
        return this.findContributedMethodForEvaluatedParameters(target, name, parameters, context, true);
    }

    public ObjectMethod findContributedMethodForEvaluatedParameters(Object target, String name, Object[] parameters, IEolContext context, boolean overrideContextOperationContributorRegistry) {
        return this.createObjectMethodFor(target, name, parameters, context, !overrideContextOperationContributorRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectMethod createObjectMethodFor(Object target, String name, Object[] parameters, IEolContext context, boolean allowContravariantConversionForParameters) {
        Method method = null;
        if (this.getReflectionTarget(target) == this && this.cachedMethodNames == null) {
            OperationContributor operationContributor = this;
            synchronized (operationContributor) {
                if (this.cachedMethodNames == null) {
                    this.cachedMethodNames = ReflectionUtil.getMethodNames(this, this.includeInheritedMethods());
                }
            }
        }
        if (this.cachedMethodNames == null || this.cachedMethodNames.contains(name)) {
            method = ReflectionUtil.getMethodFor(this.getReflectionTarget(target), name, parameters, this.includeInheritedMethods(), allowContravariantConversionForParameters);
        }
        if (method != null) {
            Object reflectionTarget = this.getReflectionTarget(target);
            ObjectMethod objectMethod = new ObjectMethod(reflectionTarget, method);
            if (reflectionTarget == this) {
                this.setTarget(target);
                this.setContext(context);
            }
            return objectMethod;
        }
        return null;
    }

    protected boolean includeInheritedMethods() {
        return false;
    }

    protected Object getReflectionTarget(Object target) {
        return this;
    }

    protected Object getTarget() {
        return this.target.get();
    }

    public void setTarget(Object target) {
        this.target.set(target);
    }

    public void setContext(IEolContext context) {
        this.context.set(context);
    }

    protected IEolContext getContext() {
        return this.context.get();
    }

    @Override
    public void close() {
        this.target.remove();
        this.context.remove();
    }
}

