/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.declarative;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.OperationCallExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolIllegalOperationParametersException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.operations.AbstractOperation;
import org.eclipse.epsilon.eol.function.CheckedEolFunction;
import org.eclipse.epsilon.eol.function.CheckedEolPredicate;
import org.eclipse.epsilon.eol.function.EolLambdaFactory;
import org.eclipse.epsilon.eol.types.EolCollectionType;
import org.eclipse.epsilon.eol.types.EolType;

public class FirstOrderOperation
extends AbstractOperation {
    protected static Variable createIteratorVariable(Object item, Parameter parameter, IEolContext context) throws EolRuntimeException {
        return new Variable(parameter.getName(), item, parameter.getType(context), true);
    }

    protected Collection<Object> resolveSource(Object target, List<Parameter> iterators, IEolContext context) throws EolRuntimeException {
        Collection source = CollectionUtil.asCollection((Object)target);
        if (!iterators.isEmpty()) {
            EolType iteratorType = iterators.get(0).getType(context);
            Collection<Object> result = EolCollectionType.createSameType(source);
            for (Object item : source) {
                if (!iteratorType.isKind(item)) continue;
                result.add(item);
            }
            return result;
        }
        return source;
    }

    protected final CheckedEolFunction<Object, ?> resolveFunction(NameExpression operationNameExpression, List<Parameter> iterators, Expression expression, IEolContext context) throws EolRuntimeException {
        return (CheckedEolFunction)this.resolve(CheckedEolFunction.class, operationNameExpression, iterators, expression, context);
    }

    protected final CheckedEolPredicate<Object> resolvePredicate(NameExpression operationNameExpression, List<Parameter> iterators, Expression expression, IEolContext context) throws EolRuntimeException {
        return (CheckedEolPredicate)this.resolve(CheckedEolPredicate.class, operationNameExpression, iterators, expression, context);
    }

    protected <F> F resolve(Class<?> fType, NameExpression operationNameExpression, List<Parameter> iterators, Expression expression, IEolContext context) throws EolRuntimeException {
        if (iterators.isEmpty()) {
            Object exprValue = expression.execute(context);
            try {
                return (F)fType.cast(exprValue);
            }
            catch (ClassCastException ccx) {
                throw new EolIllegalOperationParametersException(((OperationCallExpression)expression.getParent()).getName(), fType.getSimpleName(), Objects.toString(exprValue), expression);
            }
        }
        return (F)EolLambdaFactory.resolveFor(fType, iterators, expression, (ModuleElement)operationNameExpression, context);
    }

    @Deprecated
    public Object execute(Object target, Variable iterator, Expression expression, IEolContext context) throws EolRuntimeException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object execute(Object target, NameExpression operationNameExpression, List<Parameter> iterators, List<Expression> expressions, IEolContext context) throws EolRuntimeException {
        return this.execute(target, new Variable(iterators.get(0).getName(), iterators.get(0).getType(context)), expressions.get(0), context);
    }
}

