/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.declarative;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.operations.declarative.CollectBasedOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.CollectOperation;
import org.eclipse.epsilon.eol.execute.prettyprinting.PrettyPrinterManager;
import org.eclipse.epsilon.eol.types.EolSequence;
import org.eclipse.epsilon.eol.types.NumberUtil;

public class SortByOperation
extends CollectBasedOperation {
    @Override
    public EolSequence<Object> execute(Object target, NameExpression operationNameExpression, List<Parameter> iterators, List<Expression> expressions, IEolContext context) throws EolRuntimeException {
        Collection<Object> source = this.resolveSource(target, iterators, context);
        if (source.isEmpty()) {
            return new EolSequence<Object>();
        }
        List collected = CollectionUtil.asList((Collection)((CollectOperation)this.getDelegateOperation()).execute(target, operationNameExpression, (List)iterators, (List)expressions, context));
        int colSize = collected.size();
        assert (colSize == source.size());
        DecoratedObject[] decoratedObjects = new DecoratedObject[colSize];
        Iterator<Object> sourceIter = source.iterator();
        Iterator collectedIter = collected.iterator();
        int i = 0;
        while (i < colSize) {
            decoratedObjects[i] = new DecoratedObject(sourceIter.next(), collectedIter.next());
            ++i;
        }
        Arrays.parallelSort(decoratedObjects, new DecoratedObjectComparator(context.getPrettyPrinterManager()));
        EolSequence<Object> result = new EolSequence<Object>();
        result.ensureCapacity(decoratedObjects.length);
        DecoratedObject[] decoratedObjectArray = decoratedObjects;
        int n = decoratedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            DecoratedObject decorated = decoratedObjectArray[n2];
            result.add(decorated.object);
            ++n2;
        }
        return result;
    }

    protected static class DecoratedObject {
        public final Object object;
        public final Object decoration;

        public DecoratedObject(Object object, Object decoration) {
            this.object = object;
            this.decoration = decoration;
        }
    }

    protected static class DecoratedObjectComparator
    implements Comparator<DecoratedObject> {
        protected PrettyPrinterManager p;

        public DecoratedObjectComparator(PrettyPrinterManager p) {
            this.p = p;
        }

        @Override
        public int compare(DecoratedObject do1, DecoratedObject do2) {
            Object o1 = do1.decoration;
            Object o2 = do2.decoration;
            if (o1 instanceof Number && o2 instanceof Number) {
                if (NumberUtil.greaterThan((Number)o2, (Number)o1)) {
                    return -1;
                }
                if (NumberUtil.greaterThan((Number)o1, (Number)o2)) {
                    return 1;
                }
                return 0;
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            return this.p.print(o1).compareTo(this.p.print(o2));
        }
    }
}

