/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.declarative.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.concurrent.EolContextParallel;
import org.eclipse.epsilon.eol.execute.context.concurrent.IEolContextParallel;
import org.eclipse.epsilon.eol.execute.operations.declarative.CollectOperation;
import org.eclipse.epsilon.eol.function.CheckedEolFunction;
import org.eclipse.epsilon.eol.types.EolBag;
import org.eclipse.epsilon.eol.types.EolCollection;
import org.eclipse.epsilon.eol.types.EolCollectionType;
import org.eclipse.epsilon.eol.types.EolSequence;

public class ParallelCollectOperation
extends CollectOperation {
    @Override
    public Collection<?> execute(Object target, NameExpression operationNameExpression, List<Parameter> iterators, List<Expression> expressions, IEolContext context_) throws EolRuntimeException {
        EolCollection resultsCol;
        Collection<Object> source = this.resolveSource(target, iterators, context_);
        int sourceSize = source.size();
        EolCollection eolCollection = resultsCol = EolCollectionType.isOrdered(source) ? new EolSequence() : new EolBag();
        if (resultsCol instanceof EolSequence) {
            ((EolSequence)resultsCol).ensureCapacity(sourceSize);
        }
        IEolContextParallel context = EolContextParallel.convertToParallel(context_);
        ArrayList<Callable<Object>> jobs = new ArrayList<Callable<Object>>(sourceSize);
        Expression expression = expressions.get(0);
        CheckedEolFunction<Object, ?> function = this.resolveFunction(operationNameExpression, iterators, expression, context);
        for (Object item : source) {
            jobs.add(() -> function.applyThrows(item));
        }
        resultsCol.addAll(context.executeAll(expression, jobs));
        return resultsCol;
    }
}

