/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.declarative.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.concurrent.EolContextParallel;
import org.eclipse.epsilon.eol.execute.context.concurrent.IEolContextParallel;
import org.eclipse.epsilon.eol.execute.operations.declarative.CountOperation;
import org.eclipse.epsilon.eol.function.CheckedEolPredicate;

public class ParallelCountOperation
extends CountOperation {
    @Override
    public Integer execute(Object target, NameExpression operationNameExpression, List<Parameter> iterators, List<Expression> expressions, IEolContext context_) throws EolRuntimeException {
        IEolContextParallel context = EolContextParallel.convertToParallel(context_);
        Collection<Object> source = this.resolveSource(target, iterators, context);
        Expression expression = expressions.get(0);
        CheckedEolPredicate<Object> predicate = this.resolvePredicate(operationNameExpression, iterators, expression, context);
        AtomicInteger result = new AtomicInteger();
        ArrayList<Callable<Object>> jobs = new ArrayList<Callable<Object>>(source.size());
        for (Object item : source) {
            jobs.add(() -> {
                if (predicate.testThrows(item)) {
                    result.incrementAndGet();
                }
                return null;
            });
        }
        context.executeAll(expression, jobs);
        return result.get();
    }
}

