/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.simple;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.operations.AbstractOperation;

public abstract class SimpleOperation
extends AbstractOperation {
    @Override
    public Object execute(Object target, NameExpression operationNameExpression, List<Parameter> iterators, List<Expression> expressions, IEolContext context) throws EolRuntimeException {
        ArrayList<Object> parameters = new ArrayList<Object>(expressions.size());
        Iterator<Expression> it = expressions.iterator();
        ExecutorFactory executorFactory = context.getExecutorFactory();
        int parameterIndex = 0;
        while (it.hasNext()) {
            try {
                parameters.add(executorFactory.execute(it.next(), context));
            }
            catch (EolRuntimeException ex) {
                if (this.getTolerateExceptionInParameter(parameterIndex)) {
                    parameters.add(ex);
                }
                throw ex;
            }
            catch (Throwable t) {
                context.getErrorStream().println("THROWABLE " + t.getClass().getName());
            }
            ++parameterIndex;
        }
        try {
            return this.execute(target, parameters, context, operationNameExpression);
        }
        catch (EolRuntimeException ex) {
            if (ex.getAst() == null) {
                ex.setAst(operationNameExpression);
            }
            throw ex;
        }
    }

    public abstract Object execute(Object var1, List<?> var2, IEolContext var3, ModuleElement var4) throws EolRuntimeException;

    public boolean getTolerateExceptionInParameter(int parameterIndex) {
        return false;
    }
}

