/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.function;

import java.util.Iterator;
import java.util.List;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolIllegalOperationException;
import org.eclipse.epsilon.eol.exceptions.EolIllegalReturnException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.context.concurrent.EolContextParallel;

public class EolLambdaFactory {
    public static Object resolveFor(Class<?> clazz, List<Parameter> iteratorParams, Expression lambdaExpr, ModuleElement ast, IEolContext context) throws EolIllegalOperationException {
        return EolLambdaFactory.resolveFor(clazz.getSimpleName(), iteratorParams, lambdaExpr, ast, context);
    }

    public static Object resolveFor(String clazzName, List<Parameter> iteratorParams, Expression lambdaExpr, ModuleElement ast, IEolContext context) throws EolIllegalOperationException {
        if ((clazzName = clazzName.toLowerCase().replace("checkedeol", "")).startsWith("get")) {
            clazzName = clazzName.substring(3);
        }
        switch (clazzName) {
            case "runnable": {
                return () -> {
                    Object r = EolLambdaFactory.executeExpression(context, lambdaExpr, null, lambdaExpr, iteratorParams, new Object[0]);
                };
            }
            case "consumer": {
                return t -> {
                    Object r = EolLambdaFactory.executeExpression(context, ast, null, lambdaExpr, iteratorParams, t);
                };
            }
            case "supplier": {
                return () -> EolLambdaFactory.executeExpression(context, ast, null, lambdaExpr, iteratorParams, new Object[0]);
            }
            case "fun": 
            case "func": 
            case "function": {
                return t -> EolLambdaFactory.executeExpression(context, ast, null, lambdaExpr, iteratorParams, t);
            }
            case "predicate": {
                return t -> EolLambdaFactory.executeExpression(context, ast, Boolean.class, lambdaExpr, iteratorParams, t);
            }
            case "unary": 
            case "unaryoperator": {
                return t -> EolLambdaFactory.executeExpression(context, ast, t != null ? t.getClass() : null, lambdaExpr, iteratorParams, t);
            }
            case "biconsumer": {
                return (t, u) -> {
                    Object r = EolLambdaFactory.executeExpression(context, ast, null, lambdaExpr, iteratorParams, t, u);
                };
            }
            case "bifunction": {
                return (t, u) -> EolLambdaFactory.executeExpression(context, ast, null, lambdaExpr, iteratorParams, t, u);
            }
            case "bipredicate": {
                return (t, u) -> EolLambdaFactory.executeExpression(context, ast, Boolean.class, lambdaExpr, iteratorParams, t, u);
            }
            case "binaryoperator": {
                return (t, u) -> EolLambdaFactory.executeExpression(context, ast, t != null ? t.getClass() : null, lambdaExpr, iteratorParams, t, u);
            }
        }
        throw new EolIllegalOperationException(EolLambdaFactory.class, clazzName, ast, context.getPrettyPrinterManager());
    }

    public static <R> R executeExpression(IEolContext context, ModuleElement ast, Class<R> expectedReturnType, Expression expression, List<Parameter> params, Object ... paramValues) throws EolRuntimeException {
        assert (!(context == null || (params != null && !params.isEmpty() || paramValues != null && paramValues.length != 0) && params.size() < paramValues.length));
        if (context instanceof EolContextParallel) {
            context = ((EolContextParallel)context).getShadow();
        }
        FrameStack scope = context.getFrameStack();
        scope.enterLocal(FrameType.UNPROTECTED, (ModuleElement)expression, new Variable[0]);
        if (params != null && paramValues != null) {
            Iterator<Parameter> paramsIter = params.iterator();
            Object[] objectArray = paramValues;
            int n = paramValues.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                scope.put(paramsIter.next().getName(), value);
                ++n2;
            }
        }
        Object result = context.getExecutorFactory().execute(expression, context);
        scope.leaveLocal(expression);
        try {
            return (R)result;
        }
        catch (ClassCastException ccx) {
            throw new EolIllegalReturnException(expectedReturnType.getName(), result, ast, context);
        }
    }
}

