/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.launch;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.epsilon.common.function.CheckedRunnable;
import org.eclipse.epsilon.common.util.profiling.BenchmarkUtils;
import org.eclipse.epsilon.common.util.profiling.ProfileDiagnostic;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.function.CheckedEolConsumer;
import org.eclipse.epsilon.eol.function.CheckedEolFunction;
import org.eclipse.epsilon.eol.function.CheckedEolRunnable;
import org.eclipse.epsilon.eol.function.CheckedEolSupplier;

public interface ProfilableIEolModule
extends IEolModule {
    public Collection<ProfileDiagnostic> getProfiledStages();

    default public void profileExecution(Consumer<EolRuntimeException> exceptionHandler) {
        try {
            this.profileExecution();
        }
        catch (RuntimeException | EolRuntimeException rx) {
            exceptionHandler.accept(EolRuntimeException.findCause(rx));
        }
    }

    default public void addProfileInfo(String stage, long nanos, long memory) {
        BenchmarkUtils.addProfileInfo(this.getProfiledStages(), (String)stage, (long)nanos, (long)memory);
    }

    default public Object profileExecution() throws EolRuntimeException {
        String stage = "executeImpl";
        Object result = this.profileExecutionStage("executeImpl", this::execute);
        BenchmarkUtils.removeGCTimeFromStage(this.getProfiledStages(), (String)"executeImpl");
        return result;
    }

    default public <T, R> R profileExecutionStage(String description, Function<T, R> code, T argument) {
        return (R)BenchmarkUtils.profileExecutionStage(this.getProfiledStages(), (String)description, code, argument);
    }

    default public <R> R profileExecutionStage(String description, Supplier<R> code) {
        return (R)BenchmarkUtils.profileExecutionStage(this.getProfiledStages(), (String)description, code);
    }

    default public <T> void profileExecutionStage(String description, Consumer<T> code, T argument) {
        BenchmarkUtils.profileExecutionStage(this.getProfiledStages(), (String)description, code, argument);
    }

    default public void profileExecutionStage(String description, Runnable code) {
        BenchmarkUtils.profileExecutionStage(this.getProfiledStages(), (String)description, (Runnable)code);
    }

    default public <T, R> R profileExecutionStage(String description, CheckedEolFunction<T, R> code, T argument) throws EolRuntimeException {
        return (R)BenchmarkUtils.profileExecutionStage(this.getProfiledStages(), (String)description, code, argument);
    }

    default public <R> R profileExecutionStage(String description, CheckedEolSupplier<R> code) throws EolRuntimeException {
        return (R)BenchmarkUtils.profileExecutionStage(this.getProfiledStages(), (String)description, code);
    }

    default public <T> void profileExecutionStage(String description, CheckedEolConsumer<T> code, T argument) throws EolRuntimeException {
        BenchmarkUtils.profileExecutionStage(this.getProfiledStages(), (String)description, code, argument);
    }

    default public void profileExecutionStage(String description, CheckedEolRunnable code) throws EolRuntimeException {
        BenchmarkUtils.profileExecutionStage(this.getProfiledStages(), (String)description, (CheckedRunnable)code);
    }
}

